/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.botania.handlers;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeElvenTrade;

@ZenClass(value="mods.botania.ElvenTrade")
@ModOnly(value="botania")
@ZenRegister
public class ElvenTrade {
    protected static final String name = "Botania Eleven Trade";

    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IIngredient[] input) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(new RecipeElvenTrade(InputHelper.toStacks((IItemStack[])outputs), InputHelper.toObjects((IIngredient[])input))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(output));
    }

    public static IItemStack[] toStacks(ItemStack[] iIngredient) {
        ArrayList<MCItemStack> stacks = new ArrayList<MCItemStack>();
        for (ItemStack stack : iIngredient) {
            stacks.add(new MCItemStack(stack));
        }
        return stacks.toArray(new IItemStack[stacks.size()]);
    }

    private static class Remove
    extends BaseListRemoval<RecipeElvenTrade> {
        final IIngredient output;

        public Remove(IIngredient output) {
            super(ElvenTrade.name, BotaniaAPI.elvenTradeRecipes);
            this.output = output;
        }

        public String getRecipeInfo(RecipeElvenTrade recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutputs());
        }

        public void apply() {
            LinkedList<RecipeElvenTrade> recipes = new LinkedList<RecipeElvenTrade>();
            for (RecipeElvenTrade entry : BotaniaAPI.elvenTradeRecipes) {
                if (entry == null || entry.getOutputs() == null || !StackHelper.matches((IIngredient)this.output, (IItemStack[])ElvenTrade.toStacks(entry.getOutputs().toArray(new ItemStack[entry.getOutputs().size()])))) continue;
                recipes.add(entry);
            }
            if (!recipes.isEmpty()) {
                this.recipes.addAll(recipes);
                super.apply();
            } else {
                LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", ElvenTrade.name, this.output.toString()));
            }
            CraftTweakerAPI.getLogger().logInfo(super.describe());
        }

        public String describe() {
            return "Attempting to remove Elven Trade recipe for " + this.output.getItems();
        }
    }

    private static class Add
    extends BaseListAddition<RecipeElvenTrade> {
        public Add(RecipeElvenTrade recipe) {
            super(ElvenTrade.name, BotaniaAPI.elvenTradeRecipes, Collections.singletonList(recipe));
        }

        public String getRecipeInfo(RecipeElvenTrade recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutputs());
        }
    }
}

