/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module.worldserver;

import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMDebugHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMUtils;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;

public class ModuleWorldServerEvents
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (ASMUtils.doesClassEqual(transformedName, ObfNameHelper.Classes.WORLD_SERVER)) {
            String methodDesc;
            String methodName;
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.WORLD_SERVER_TICK.getName(), methodDesc = ObfNameHelper.Methods.WORLD_SERVER_TICK.getDescriptor());
            if (method != null) {
                ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
                if (this.addWorldServerTickHook(method, transformedName)) {
                    ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                    return ASMHelper.writeClassToBytes(classNode, 3);
                }
            } else {
                ASMDebugHelper.logNotFound(methodName, transformedName);
            }
            if ((method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.WORLD_SERVER_UPDATE_ENTITIES.getName(), methodDesc = ObfNameHelper.Methods.WORLD_SERVER_UPDATE_ENTITIES.getDescriptor())) != null) {
                ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
                if (this.addWorldServerUpdateEntitiesHook(method, transformedName)) {
                    ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                    return ASMHelper.writeClassToBytes(classNode, 3);
                }
            } else {
                ASMDebugHelper.logNotFound(methodName, transformedName);
            }
        }
        return basicClass;
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.WORLD_SERVER.getName()};
    }

    @Override
    public String getModuleName() {
        return "worldServerEvents";
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry arg0) {
    }

    private boolean addWorldServerTickHook(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.findFirstInstruction(method);
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name, transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ON_WORLD_SERVER_TICK_PRE.toInsnNode(184));
        LabelNode label = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, label));
        toInject.add((AbstractInsnNode)new InsnNode(177));
        toInject.add((AbstractInsnNode)label);
        method.instructions.insertBefore(target, toInject);
        return true;
    }

    private boolean addWorldServerUpdateEntitiesHook(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.findFirstInstruction(method);
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name, transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ON_WORLD_SERVER_UPDATE_ENTITIES_PRE.toInsnNode(184));
        LabelNode label = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, label));
        toInject.add((AbstractInsnNode)new InsnNode(177));
        toInject.add((AbstractInsnNode)label);
        method.instructions.insertBefore(target, toInject);
        return true;
    }
}

