/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftblib.events.universe.UniverseClosedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseLoadedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseSavedEvent;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.MessageSyncEditingMode;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import io.sommers.packmode.api.PackModeAPI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ftbquests")
public class FTBQuestsWorldData
implements IConfigCallback {
    public static FTBQuestsWorldData INSTANCE;
    public final Universe universe;
    public final List<String> extraFiles;

    @SubscribeEvent
    public static void onUniversePreLoaded(UniverseLoadedEvent.Pre event) {
        INSTANCE = new FTBQuestsWorldData(event.getUniverse());
        if (ServerQuestFile.INSTANCE != null) {
            ServerQuestFile.INSTANCE.unload();
        }
        ServerQuestFile.INSTANCE = new ServerQuestFile(event.getUniverse());
        ServerQuestFile.INSTANCE.load();
        int c = ServerQuestFile.INSTANCE.chapters.size();
        int v = ServerQuestFile.INSTANCE.variables.size();
        int q = 0;
        int t = 0;
        int r = 0;
        for (QuestChapter chapter : ServerQuestFile.INSTANCE.chapters) {
            q += chapter.quests.size();
            for (Quest quest : chapter.quests) {
                t += quest.tasks.size();
                r += quest.rewards.size();
            }
        }
        FTBQuests.LOGGER.info(String.format("Loaded %d chapters, %d quests, %d tasks, %d rewards and %d variables. In total, %d objects", c, q, t, r, v, c + q + t + r + v));
        NBTTagCompound nbt = event.getData("ftbquests");
        FTBQuestsWorldData.INSTANCE.extraFiles.clear();
        NBTTagList list = nbt.func_150295_c("ExtraFiles", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            FTBQuestsWorldData.INSTANCE.extraFiles.add(list.func_150307_f(i));
        }
        if (ServerQuestFile.INSTANCE.fileVersion != 5) {
            FTBQuests.LOGGER.info("File version changed " + ServerQuestFile.INSTANCE.fileVersion + " -> " + 5);
            ServerQuestFile.INSTANCE.saveNow();
        }
    }

    private static String getFolderName() {
        if (Loader.isModLoaded((String)"packmode")) {
            return FTBQuestsWorldData.getPackmodeFolderName();
        }
        return "normal";
    }

    private static String getPackmodeFolderName() {
        return PackModeAPI.getInstance().getCurrentPackMode();
    }

    @SubscribeEvent
    public static void onUniverseSaved(UniverseSavedEvent event) {
        if (ServerQuestFile.INSTANCE != null && ServerQuestFile.INSTANCE.shouldSave) {
            ServerQuestFile.INSTANCE.saveNow();
            ServerQuestFile.INSTANCE.shouldSave = false;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        if (!FTBQuestsWorldData.INSTANCE.extraFiles.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (String file : FTBQuestsWorldData.INSTANCE.extraFiles) {
                list.func_74742_a((NBTBase)new NBTTagString(file));
            }
            nbt.func_74782_a("ExtraFiles", (NBTBase)list);
        }
        if (!nbt.func_82582_d()) {
            event.setData("ftbquests", nbt);
        }
    }

    @SubscribeEvent
    public static void onUniverseClosed(UniverseClosedEvent event) {
        if (ServerQuestFile.INSTANCE != null) {
            ServerQuestFile.INSTANCE.unload();
            ServerQuestFile.INSTANCE = null;
        }
        INSTANCE = null;
    }

    private FTBQuestsWorldData(Universe u) {
        this.universe = u;
        this.extraFiles = new ArrayList<String>();
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        for (EntityPlayerMP player : this.universe.server.func_184103_al().func_181057_v()) {
            new MessageSyncEditingMode(FTBQuests.canEdit(player)).sendTo(player);
        }
    }
}

