/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.GuiSelectQuestObject;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ConfigQuestObject
extends ConfigValue {
    public static final String ID = "ftbquests_object";
    public final QuestFile file;
    private final IntSet validObjects;
    private QuestObjectBase object;

    public ConfigQuestObject(QuestFile f, @Nullable QuestObjectBase o, IntSet t) {
        this.file = f;
        this.object = o;
        this.validObjects = new IntOpenHashSet((IntCollection)t);
    }

    public ConfigQuestObject(QuestFile f, @Nullable QuestObjectBase o, Predicate<QuestObjectBase> t) {
        this(f, o, (IntSet)IntSets.EMPTY_SET);
        if (t.test(null)) {
            this.validObjects.add(0);
        }
        for (QuestObjectBase objectBase : f.getAllObjects()) {
            if (!t.test(objectBase)) continue;
            this.validObjects.add(objectBase.id);
        }
    }

    public boolean isValid(int id) {
        return this.validObjects.contains(id);
    }

    public boolean isValid(@Nullable QuestObjectBase object) {
        return this.isValid(object == null ? 0 : object.id);
    }

    public String getID() {
        return ID;
    }

    public void setObject(@Nullable QuestObjectBase v) {
        this.object = v;
    }

    @Nullable
    public QuestObjectBase getObject() {
        return this.object;
    }

    public String getString() {
        this.object = this.getObject();
        return this.object == null ? "" : this.object.toString();
    }

    public boolean getBoolean() {
        return this.getObject() != null;
    }

    public int getInt() {
        this.object = this.getObject();
        return this.object == null ? 0 : this.object.id;
    }

    public ConfigQuestObject copy() {
        return new ConfigQuestObject(this.file, this.object, this.validObjects);
    }

    public ITextComponent getStringForGUI() {
        this.object = this.getObject();
        if (this.object == null) {
            return new TextComponentString("");
        }
        return new TextComponentString(this.object.getUnformattedTitle());
    }

    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button, Runnable callback) {
        if (inst.getCanEdit()) {
            new GuiSelectQuestObject(this, gui, callback).openGui();
        }
    }

    public void writeData(DataOut data) {
        data.writeIntList((IntCollection)this.validObjects);
        data.writeInt(this.getInt());
    }

    public void readData(DataIn data) {
        this.validObjects.clear();
        this.validObjects.addAll((IntCollection)data.readIntList());
        QuestObjectBase o = this.file.getBase(data.readInt());
        if (this.isValid(o)) {
            this.setObject(o);
        }
    }

    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        QuestObjectBase o = this.file.getBase(QuestFile.getID(string));
        if (this.isValid(o)) {
            if (!simulate) {
                this.setObject(o);
            }
            return true;
        }
        return false;
    }

    public void addInfo(ConfigValueInstance inst, List<String> list) {
        if (inst.getCanEdit() && !inst.getDefaultValue().isNull()) {
            list.add(TextFormatting.AQUA + "Default: " + TextFormatting.RESET + inst.getDefaultValue().getStringForGUI().func_150254_d());
        }
        if (this.object != null) {
            list.add(TextFormatting.AQUA + "ID: " + TextFormatting.RESET + this.object);
        }
    }

    public void setValueFromOtherValue(ConfigValue value) {
        QuestObjectBase o;
        if (value instanceof ConfigQuestObject) {
            this.validObjects.clear();
            this.validObjects.addAll((IntCollection)((ConfigQuestObject)value).validObjects);
        }
        if (this.isValid(o = this.file.getBase(value.getInt()))) {
            this.setObject(o);
        }
    }

    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.object = this.getObject();
        if (this.object != null) {
            nbt.func_74768_a(key, this.object.id);
        }
    }

    public void readFromNBT(NBTTagCompound nbt, String key) {
        QuestObjectBase o = this.file.getBase(nbt.func_74762_e(key));
        if (this.isValid(o)) {
            this.setObject(o);
        }
    }
}

