/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfig;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.ISingleLongValueTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public final class QuestTaskType
extends IForgeRegistryEntry.Impl<QuestTaskType> {
    private static ForgeRegistry<QuestTaskType> REGISTRY;
    public final Provider provider;
    private String displayName;
    private Icon icon;
    private GuiProvider guiProvider;

    public static void createRegistry() {
        if (REGISTRY == null) {
            ResourceLocation registryName = new ResourceLocation("ftbquests", "tasks");
            REGISTRY = (ForgeRegistry)new RegistryBuilder().setType(QuestTaskType.class).setName(registryName).create();
            MinecraftForge.EVENT_BUS.post((Event)new RegistryEvent.Register(registryName, REGISTRY));
        }
    }

    public static ForgeRegistry<QuestTaskType> getRegistry() {
        return REGISTRY;
    }

    @Nullable
    public static QuestTask createTask(Quest quest, String id) {
        if (id.isEmpty()) {
            id = "ftbquests:item";
        } else if (id.indexOf(58) == -1) {
            id = "ftbquests:" + id;
        }
        QuestTaskType type = (QuestTaskType)REGISTRY.getValue(new ResourceLocation(id));
        if (type == null) {
            if (id.equals("ftbquests:ftb_money")) {
                return QuestTaskType.createTask(quest, "ftbmoney:money");
            }
            return null;
        }
        return type.provider.create(quest);
    }

    public QuestTaskType(Provider p) {
        this.provider = p;
        this.displayName = null;
        this.icon = GuiIcons.ACCEPT;
        this.guiProvider = new GuiProvider(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void openCreationGui(IOpenableGui gui, Quest quest, Consumer<QuestTask> callback) {
                QuestTask task = QuestTaskType.this.provider.create(quest);
                if (task instanceof ISingleLongValueTask) {
                    new GuiEditConfigValue("value", (ConfigValue)((ISingleLongValueTask)((Object)task)).getDefaultValue(), (value, set) -> {
                        gui.openGui();
                        if (set) {
                            ((ISingleLongValueTask)((Object)task)).setValue(value.getLong());
                            callback.accept(task);
                        }
                    }).openGui();
                    return;
                }
                ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
                task.getConfig((EntityPlayer)Minecraft.func_71410_x().field_71439_g, task.createSubGroup(group));
                new GuiEditConfig(group, (g1, sender) -> callback.accept(task)).openGui();
            }
        };
    }

    public String getTypeForNBT() {
        return this.getRegistryName().func_110624_b().equals("ftbquests") ? this.getRegistryName().func_110623_a() : this.getRegistryName().toString();
    }

    public QuestTaskType setDisplayName(String name) {
        this.displayName = name;
        return this;
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        ResourceLocation id = this.getRegistryName();
        return id == null ? "error" : I18n.func_135052_a((String)("ftbquests.task." + id.func_110624_b() + '.' + id.func_110623_a()), (Object[])new Object[0]);
    }

    public QuestTaskType setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public QuestTaskType setGuiProvider(GuiProvider p) {
        this.guiProvider = p;
        return this;
    }

    public GuiProvider getGuiProvider() {
        return this.guiProvider;
    }

    public static interface GuiProvider {
        @SideOnly(value=Side.CLIENT)
        public void openCreationGui(IOpenableGui var1, Quest var2, Consumer<QuestTask> var3);
    }

    @FunctionalInterface
    public static interface Provider {
        public QuestTask create(Quest var1);
    }
}

