/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class LocationTask
extends QuestTask {
    public int dimension = 0;
    public boolean ignoreDimension = false;
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int w = 1;
    public int h = 1;
    public int d = 1;

    public LocationTask(Quest quest) {
        super(quest);
    }

    @Override
    public QuestTaskType getType() {
        return FTBQuestsTasks.LOCATION;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74783_a("location", new int[]{this.dimension, this.x, this.y, this.z, this.w, this.h, this.d});
        if (this.ignoreDimension) {
            nbt.func_74757_a("ignore_dim", true);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        int[] ai = nbt.func_74759_k("location");
        if (ai.length != 7) {
            ai = new int[7];
        }
        this.dimension = ai[0];
        this.x = ai[1];
        this.y = ai[2];
        this.z = ai[3];
        this.w = ai[4];
        this.h = ai[5];
        this.d = ai[6];
        this.ignoreDimension = nbt.func_74767_n("ignore_dim");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.dimension);
        data.writeBoolean(this.ignoreDimension);
        data.writeVarInt(this.x);
        data.writeVarInt(this.y);
        data.writeVarInt(this.z);
        data.writeVarInt(this.w);
        data.writeVarInt(this.h);
        data.writeVarInt(this.d);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.dimension = data.readVarInt();
        this.ignoreDimension = data.readBoolean();
        this.x = data.readVarInt();
        this.y = data.readVarInt();
        this.z = data.readVarInt();
        this.w = data.readVarInt();
        this.h = data.readVarInt();
        this.d = data.readVarInt();
    }

    @Override
    public void getConfig(EntityPlayer player, ConfigGroup config) {
        super.getConfig(player, config);
        config.addInt("dim", () -> this.dimension, v -> {
            this.dimension = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addBool("ignore_dim", () -> this.ignoreDimension, v -> {
            this.ignoreDimension = v;
        }, false);
        config.addInt("x", () -> this.x, v -> {
            this.x = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("y", () -> this.y, v -> {
            this.y = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("z", () -> this.z, v -> {
            this.z = v;
        }, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.addInt("w", () -> this.w, v -> {
            this.w = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addInt("h", () -> this.h, v -> {
            this.h = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addInt("d", () -> this.d, v -> {
            this.d = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @Override
    public boolean autoSubmitOnPlayerTick() {
        return true;
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<LocationTask> {
        private Data(LocationTask task, ITeamData data) {
            super(task, data);
        }

        @Override
        public String getProgressString() {
            return this.progress > 0L ? "1" : "0";
        }

        @Override
        public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
            int z;
            int x;
            int y;
            if (this.progress == 0L && (((LocationTask)this.task).ignoreDimension || ((LocationTask)this.task).dimension == player.field_71093_bK) && (y = MathHelper.func_76128_c((double)player.field_70163_u)) >= ((LocationTask)this.task).y && y < ((LocationTask)this.task).y + ((LocationTask)this.task).h && (x = MathHelper.func_76128_c((double)player.field_70165_t)) >= ((LocationTask)this.task).x && x < ((LocationTask)this.task).x + ((LocationTask)this.task).w && (z = MathHelper.func_76128_c((double)player.field_70161_v)) >= ((LocationTask)this.task).z && z < ((LocationTask)this.task).z + ((LocationTask)this.task).d) {
                if (!simulate) {
                    this.progress = 1L;
                    this.sync();
                }
                return true;
            }
            return false;
        }
    }
}

