/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class KillTask
extends QuestTask {
    public static final ResourceLocation ZOMBIE = new ResourceLocation("minecraft:zombie");
    public ResourceLocation entity = ZOMBIE;
    public long value = 100L;

    public static StatBase get(String id) {
        for (StatBase base : StatList.field_188094_c) {
            if (!base.field_75975_e.equals(id)) continue;
            return base;
        }
        return StatList.field_188070_B;
    }

    public KillTask(Quest quest) {
        super(quest);
    }

    @Override
    public QuestTaskType getType() {
        return FTBQuestsTasks.KILL;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("entity", this.entity.toString());
        nbt.func_74772_a("value", this.value);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.entity = new ResourceLocation(nbt.func_74779_i("entity"));
        this.value = nbt.func_74762_e("value");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.entity.toString());
        data.writeVarLong(this.value);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.entity = new ResourceLocation(data.readString());
        this.value = data.readVarInt();
    }

    @Override
    public void getConfig(EntityPlayer player, ConfigGroup config) {
        super.getConfig(player, config);
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        for (EntityEntry entry : ForgeRegistries.ENTITIES) {
            if (!EntityLivingBase.class.isAssignableFrom(entry.getEntityClass())) continue;
            ids.add(entry.getRegistryName());
        }
        config.addEnum("entity", () -> this.entity, v -> {
            this.entity = v;
        }, NameMap.create((Object)ZOMBIE, (NameMap.ObjectProperties)NameMap.ObjectProperties.withName((sender, s) -> new TextComponentTranslation("entity." + EntityList.func_191302_a((ResourceLocation)s) + ".name", new Object[0])), (Object[])ids.toArray(new ResourceLocation[0])));
        config.addLong("value", () -> this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE);
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.task.ftbquests.kill.title", (Object[])new Object[]{this.getMaxProgressString(), I18n.func_135052_a((String)("entity." + EntityList.func_191302_a((ResourceLocation)this.entity) + ".name"), (Object[])new Object[0])});
    }

    @Override
    public Icon getAltIcon() {
        if (EntityList.field_75627_a.containsKey(this.entity)) {
            ItemStack stack = new ItemStack(Items.field_151063_bx);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("id", this.entity.toString());
            stack.func_77983_a("EntityTag", (NBTBase)nbt);
            return ItemIcon.getItemIcon((ItemStack)stack);
        }
        return super.getAltIcon();
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<KillTask> {
        private Data(KillTask task, ITeamData data) {
            super(task, data);
        }

        public void kill(EntityLivingBase entity) {
            if (this.progress < ((KillTask)this.task).value && ((KillTask)this.task).entity.equals((Object)EntityList.func_191301_a((Entity)entity))) {
                ++this.progress;
                this.sync();
            }
        }

        @Override
        public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
            return false;
        }
    }
}

