/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.net.MessageDisplayRewardToast;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class XPReward
extends QuestReward {
    public int xp = 100;

    public XPReward(Quest quest) {
        super(quest);
    }

    @Override
    public QuestRewardType getType() {
        return FTBQuestsRewards.XP;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("xp", this.xp);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.xp = nbt.func_74762_e("xp");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.xp);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.xp = data.readVarInt();
    }

    @Override
    public void getConfig(EntityPlayer player, ConfigGroup config) {
        super.getConfig(player, config);
        config.addInt("xp", () -> this.xp, v -> {
            this.xp = v;
        }, 100, 1, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbquests.xp", new Object[0]));
    }

    @Override
    public void claim(EntityPlayerMP player) {
        player.func_71023_q(this.xp);
        if (MessageDisplayRewardToast.ENABLED) {
            TextComponentString text = new TextComponentString("+" + this.xp);
            text.func_150256_b().func_150238_a(TextFormatting.GREEN);
            new MessageDisplayRewardToast(new TextComponentTranslation("ftbquests.reward.ftbquests.xp", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)text), this.getIcon()).sendTo(player);
        }
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.reward.ftbquests.xp", (Object[])new Object[0]) + ": " + TextFormatting.GREEN + "+" + this.xp;
    }

    @Override
    public String getButtonText() {
        return "+" + this.xp;
    }
}

