/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.EnumTristate;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageClaimReward;
import com.feed_the_beast.ftbquests.net.MessageDisplayRewardToast;
import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class QuestReward
extends QuestObjectBase {
    public Quest quest;
    public EnumTristate team;
    public EnumTristate autoclaim;

    public QuestReward(Quest q) {
        this.quest = q;
        this.team = EnumTristate.DEFAULT;
        this.autoclaim = EnumTristate.DEFAULT;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.REWARD;
    }

    @Override
    public final QuestFile getQuestFile() {
        return this.quest.chapter.file;
    }

    @Override
    @Nullable
    public final QuestChapter getQuestChapter() {
        return this.quest.chapter;
    }

    @Override
    public final int getParentID() {
        return this.quest.id;
    }

    public abstract QuestRewardType getType();

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        this.team.write(nbt, "team_reward");
        this.autoclaim.write(nbt, "autoclaim");
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.team = EnumTristate.read((NBTTagCompound)nbt, (String)"team_reward");
        this.autoclaim = EnumTristate.read((NBTTagCompound)nbt, (String)"autoclaim");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        EnumTristate.NAME_MAP.write(data, (Object)this.team);
        EnumTristate.NAME_MAP.write(data, (Object)this.autoclaim);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.team = (EnumTristate)EnumTristate.NAME_MAP.read(data);
        this.autoclaim = (EnumTristate)EnumTristate.NAME_MAP.read(data);
    }

    @Override
    public void getConfig(EntityPlayer player, ConfigGroup config) {
        super.getConfig(player, config);
        config.addEnum("team", () -> this.team, v -> {
            this.team = v;
        }, EnumTristate.NAME_MAP).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.team_reward", new Object[0])).setCanEdit(!(this.quest instanceof Quest) || !this.quest.canRepeat);
        config.addEnum("autoclaim", () -> this.autoclaim, v -> {
            this.autoclaim = v;
        }, EnumTristate.NAME_MAP).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.autoclaim", new Object[0]));
    }

    public abstract void claim(EntityPlayerMP var1);

    public ItemStack claimAutomated(TileEntity tileEntity, @Nullable EntityPlayerMP player) {
        if (player != null) {
            MessageDisplayRewardToast.ENABLED = false;
            this.claim(player);
            MessageDisplayRewardToast.ENABLED = true;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public final void deleteSelf() {
        this.quest.rewards.remove(this);
        Set<QuestReward> c = Collections.singleton(this);
        for (ITeamData iTeamData : this.getQuestFile().getAllData()) {
            iTeamData.unclaimRewards(c);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        Set<QuestReward> c = Collections.singleton(this);
        for (ITeamData iTeamData : this.getQuestFile().getAllData()) {
            iTeamData.unclaimRewards(c);
        }
        super.deleteChildren();
    }

    @Override
    public void editedFromGUI() {
        GuiQuestTree gui = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
        if (gui != null && gui.getViewedQuest() != null) {
            gui.viewQuestPanel.refreshWidgets();
        }
        if (gui != null) {
            gui.questPanel.refreshWidgets();
        }
    }

    @Override
    public void onCreated() {
        this.quest.rewards.add(this);
    }

    public final boolean isTeamReward() {
        return this.quest.canRepeat || this.team.get(this.quest.chapter.file.defaultRewardTeam);
    }

    public final boolean shouldAutoClaimReward() {
        return this.autoclaim.get(this.quest.chapter.alwaysInvisible || this.quest.chapter.file.defaultRewardAutoclaim);
    }

    @Override
    public final void changeProgress(ITeamData data, EnumChangeProgress type) {
        if (type == EnumChangeProgress.RESET || type == EnumChangeProgress.RESET_DEPS) {
            data.unclaimRewards(Collections.singleton(this));
        }
    }

    @Override
    public Icon getAltIcon() {
        return this.getType().getIcon();
    }

    @Override
    public String getAltTitle() {
        return this.getType().getDisplayName();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        QuestRewardType type = this.getType();
        return group.getGroup(this.getObjectType().getID()).getGroup(type.getRegistryName().func_110624_b()).getGroup(type.getRegistryName().func_110623_a());
    }

    public void addMouseOverText(List<String> list) {
    }

    public boolean addTitleInMouseOverText() {
        return true;
    }

    public void onButtonClicked() {
        new MessageClaimReward(this.id).sendToServer();
    }

    public boolean getExcludeFromClaimAll() {
        return this.getType().getExcludeFromListRewards();
    }

    @Nullable
    public Object getIngredient() {
        return this.getIcon().getIngredient();
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    public String getButtonText() {
        return "";
    }
}

