/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigTimer;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.events.ClearFileCacheEvent;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.EnumQuestShape;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestVariable;
import com.feed_the_beast.ftbquests.quest.loot.EntityWeight;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.latmod.mods.itemfilters.item.ItemMissing;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class QuestFile
extends QuestObject {
    public static final int VERSION = 5;
    public final List<QuestChapter> chapters;
    public final List<QuestVariable> variables;
    public final List<RewardTable> rewardTables;
    private final Int2ObjectOpenHashMap<QuestObjectBase> map;
    public final RewardTable dummyTable;
    public final List<ItemStack> emergencyItems;
    public Ticks emergencyItemsCooldown;
    public int fileVersion;
    public boolean defaultRewardTeam;
    public boolean defaultTeamConsumeItems;
    public boolean defaultRewardAutoclaim;
    public EnumQuestShape defaultShape;
    public boolean dropLootCrates;
    public final EntityWeight lootCrateNoDrop;
    public boolean disableGui;

    public QuestFile() {
        this.id = 1;
        this.fileVersion = 0;
        this.chapters = new ArrayList<QuestChapter>();
        this.variables = new ArrayList<QuestVariable>();
        this.rewardTables = new ArrayList<RewardTable>();
        this.map = new Int2ObjectOpenHashMap();
        this.dummyTable = new RewardTable(this);
        this.emergencyItems = new ArrayList<ItemStack>();
        this.emergencyItems.add(new ItemStack(Items.field_151034_e));
        this.emergencyItemsCooldown = Ticks.MINUTE.x(5L);
        this.defaultRewardTeam = false;
        this.defaultTeamConsumeItems = false;
        this.defaultRewardAutoclaim = false;
        this.defaultShape = EnumQuestShape.CIRCLE;
        this.dropLootCrates = false;
        this.lootCrateNoDrop = new EntityWeight();
        this.lootCrateNoDrop.passive = 4000;
        this.lootCrateNoDrop.monster = 600;
        this.lootCrateNoDrop.boss = 0;
        this.disableGui = false;
    }

    public abstract boolean isClient();

    @Override
    public QuestFile getQuestFile() {
        return this;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.FILE;
    }

    public boolean isLoading() {
        return false;
    }

    public boolean canEdit() {
        return false;
    }

    @Override
    public int getRelativeProgressFromChildren(ITeamData data) {
        int progress = 0;
        for (QuestChapter chapter : this.chapters) {
            progress += chapter.getRelativeProgress(data);
        }
        return QuestFile.getRelativeProgressFromChildren(progress, this.chapters.size());
    }

    @Override
    public void onCompleted(ITeamData data, List<EntityPlayerMP> notifyPlayers) {
        super.onCompleted(data, notifyPlayers);
        new ObjectCompletedEvent.FileEvent(data, this).post();
        for (EntityPlayerMP player : notifyPlayers) {
            new MessageDisplayCompletionToast(this.id).sendTo(player);
        }
    }

    @Override
    public void changeProgress(ITeamData data, EnumChangeProgress type) {
        for (QuestChapter chapter : this.chapters) {
            chapter.changeProgress(data, type);
        }
    }

    @Override
    public void deleteSelf() {
        this.invalid = true;
    }

    @Override
    public void deleteChildren() {
        for (QuestChapter chapter : this.chapters) {
            chapter.deleteChildren();
            chapter.invalid = true;
        }
        this.chapters.clear();
        for (QuestVariable variable : this.variables) {
            variable.deleteChildren();
            variable.invalid = true;
        }
        this.variables.clear();
        for (RewardTable table : this.rewardTables) {
            table.deleteChildren();
            table.invalid = true;
        }
        this.rewardTables.clear();
    }

    @Nullable
    public QuestObjectBase getBase(int id) {
        if (id == 0) {
            return null;
        }
        if (id == 1) {
            return this;
        }
        QuestObjectBase object = (QuestObjectBase)this.map.get(id);
        return object == null || object.invalid ? null : object;
    }

    @Nullable
    public QuestObject get(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestObject ? (QuestObject)object : null;
    }

    @Nullable
    public QuestObjectBase remove(int id) {
        QuestObjectBase object = (QuestObjectBase)this.map.remove(id);
        if (object != null) {
            if (object instanceof QuestObject) {
                QuestObject o = (QuestObject)object;
                for (QuestChapter chapter : this.chapters) {
                    for (Quest quest : chapter.quests) {
                        quest.dependencies.remove(o);
                    }
                }
            }
            object.invalid = true;
            this.refreshIDMap();
            return object;
        }
        return null;
    }

    @Nullable
    public QuestChapter getChapter(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestChapter ? (QuestChapter)object : null;
    }

    @Nullable
    public Quest getQuest(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Quest ? (Quest)object : null;
    }

    @Nullable
    public QuestTask getTask(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestTask ? (QuestTask)object : null;
    }

    @Nullable
    public QuestVariable getVariable(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestVariable ? (QuestVariable)object : null;
    }

    @Nullable
    public QuestReward getReward(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestReward ? (QuestReward)object : null;
    }

    @Nullable
    public RewardTable getRewardTable(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof RewardTable ? (RewardTable)object : null;
    }

    @Nullable
    public LootCrate getLootCrate(String id) {
        RewardTable table;
        if (!id.startsWith("#")) {
            for (RewardTable table2 : this.rewardTables) {
                if (table2.lootCrate == null || !table2.lootCrate.stringID.equals(id)) continue;
                return table2.lootCrate;
            }
        }
        return (table = this.getRewardTable(QuestFile.getID(id))) == null ? null : table.lootCrate;
    }

    @Nullable
    public RewardTable getRewardTable(String id) {
        LootCrate crate = this.getLootCrate(id);
        return crate != null ? crate.table : this.getRewardTable(QuestFile.getID(id));
    }

    public void refreshIDMap() {
        this.clearCachedData();
        this.map.clear();
        for (RewardTable table : this.rewardTables) {
            this.map.put(table.id, (Object)table);
        }
        for (QuestChapter chapter : this.chapters) {
            this.map.put(chapter.id, (Object)chapter);
            for (Quest quest : chapter.quests) {
                this.map.put(quest.id, (Object)quest);
                for (QuestTask task : quest.tasks) {
                    this.map.put(task.id, (Object)task);
                }
                for (QuestReward reward : quest.rewards) {
                    this.map.put(reward.id, (Object)reward);
                }
            }
        }
        for (QuestVariable variable : this.variables) {
            this.map.put(variable.id, (Object)variable);
        }
        this.clearCachedData();
    }

    public QuestObjectBase create(QuestObjectType type, int parent, NBTTagCompound extra) {
        switch (type) {
            case CHAPTER: {
                return new QuestChapter(this);
            }
            case QUEST: {
                QuestChapter chapter = this.getChapter(parent);
                if (chapter != null) {
                    return new Quest(chapter);
                }
                throw new IllegalArgumentException("Parent chapter not found!");
            }
            case TASK: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    QuestTask task = QuestTaskType.createTask(quest, extra.func_74779_i("type"));
                    if (task != null) {
                        return task;
                    }
                    throw new IllegalArgumentException("Unknown task type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case VARIABLE: {
                return new QuestVariable(this);
            }
            case REWARD: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    QuestReward reward = QuestRewardType.createReward(quest, extra.func_74779_i("type"));
                    if (reward != null) {
                        return reward;
                    }
                    throw new IllegalArgumentException("Unknown reward type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case REWARD_TABLE: {
                return new RewardTable(this);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    @Override
    public final void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("version", 5);
        nbt.func_74757_a("default_reward_team", this.defaultRewardTeam);
        nbt.func_74757_a("default_consume_items", this.defaultTeamConsumeItems);
        nbt.func_74757_a("default_autoclaim_rewards", this.defaultRewardAutoclaim);
        nbt.func_74778_a("default_quest_shape", this.defaultShape.getID());
        if (!this.emergencyItems.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : this.emergencyItems) {
                list.func_74742_a(ItemMissing.write((ItemStack)stack, (boolean)true));
            }
            nbt.func_74782_a("emergency_items", (NBTBase)list);
        }
        nbt.func_74778_a("emergency_items_cooldown", this.emergencyItemsCooldown.toString());
        nbt.func_74757_a("drop_loot_crates", this.dropLootCrates);
        NBTTagCompound nbt1 = new NBTTagCompound();
        this.lootCrateNoDrop.writeData(nbt1);
        nbt.func_74782_a("loot_crate_no_drop", (NBTBase)nbt1);
        nbt.func_74757_a("disable_gui", this.disableGui);
    }

    @Override
    public final void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.defaultRewardTeam = nbt.func_74767_n("default_reward_team");
        this.defaultTeamConsumeItems = nbt.func_74767_n("default_consume_items");
        this.defaultRewardAutoclaim = nbt.func_74767_n("default_autoclaim_rewards");
        this.defaultShape = (EnumQuestShape)((Object)EnumQuestShape.NAME_MAP.get(nbt.func_74779_i("default_quest_shape")));
        this.emergencyItems.clear();
        NBTTagList list = nbt.func_150295_c("emergency_items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = ItemMissing.read((NBTBase)list.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            this.emergencyItems.add(stack);
        }
        Ticks t = Ticks.get((String)nbt.func_74779_i("emergency_items_cooldown"));
        this.emergencyItemsCooldown = t.hasTicks() ? t : Ticks.MINUTE.x(5L);
        this.dropLootCrates = nbt.func_74767_n("drop_loot_crates");
        if (nbt.func_74764_b("loot_crate_no_drop")) {
            this.lootCrateNoDrop.readData(nbt.func_74775_l("loot_crate_no_drop"));
        }
        this.disableGui = nbt.func_74767_n("disable_gui");
    }

    private NBTTagCompound createIndex(List<? extends QuestObjectBase> list) {
        int[] index = new int[list.size()];
        for (int i = 0; i < index.length; ++i) {
            index[i] = list.get((int)i).id;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a("index", index);
        return nbt;
    }

    public int[] readIndex(File file) {
        NBTTagCompound nbt = NBTUtils.readNBT((File)file);
        return nbt == null ? new int[]{} : nbt.func_74759_k("index");
    }

    public final void writeDataFull(File folder) {
        NBTTagCompound out = new NBTTagCompound();
        this.writeData(out);
        NBTUtils.writeNBTSafe((File)new File(folder, "file.nbt"), (NBTTagCompound)out);
        NBTUtils.writeNBTSafe((File)new File(folder, "chapters/index.nbt"), (NBTTagCompound)this.createIndex(this.chapters));
        NBTUtils.writeNBTSafe((File)new File(folder, "variables/index.nbt"), (NBTTagCompound)this.createIndex(this.variables));
        NBTUtils.writeNBTSafe((File)new File(folder, "reward_tables/index.nbt"), (NBTTagCompound)this.createIndex(this.rewardTables));
        for (QuestChapter chapter : this.chapters) {
            out = new NBTTagCompound();
            chapter.writeData(out);
            String chapterPath = "chapters/" + chapter.getCodeString() + "/";
            NBTUtils.writeNBTSafe((File)new File(folder, chapterPath + "chapter.nbt"), (NBTTagCompound)out);
            if (chapter.quests.isEmpty()) continue;
            for (Quest quest : chapter.quests) {
                NBTTagCompound nbt3;
                IForgeRegistryEntry.Impl type;
                if (quest.invalid) continue;
                out = new NBTTagCompound();
                quest.writeData(out);
                if (!quest.tasks.isEmpty()) {
                    NBTTagList t = new NBTTagList();
                    for (QuestTask task : quest.tasks) {
                        type = task.getType();
                        nbt3 = new NBTTagCompound();
                        task.writeData(nbt3);
                        nbt3.func_74768_a("uid", task.id);
                        nbt3.func_74778_a("type", type.getTypeForNBT());
                        t.func_74742_a((NBTBase)nbt3);
                    }
                    if (!t.func_82582_d()) {
                        out.func_74782_a("tasks", (NBTBase)t);
                    }
                }
                if (!quest.rewards.isEmpty()) {
                    NBTTagList r = new NBTTagList();
                    for (QuestReward reward : quest.rewards) {
                        type = reward.getType();
                        nbt3 = new NBTTagCompound();
                        reward.writeData(nbt3);
                        nbt3.func_74768_a("uid", reward.id);
                        nbt3.func_74778_a("type", type.getTypeForNBT());
                        r.func_74742_a((NBTBase)nbt3);
                    }
                    if (!r.func_82582_d()) {
                        out.func_74782_a("rewards", (NBTBase)r);
                    }
                }
                NBTUtils.writeNBTSafe((File)new File(folder, chapterPath + quest.getCodeString() + ".nbt"), (NBTTagCompound)out);
            }
        }
        for (QuestVariable variable : this.variables) {
            out = new NBTTagCompound();
            variable.writeData(out);
            NBTUtils.writeNBTSafe((File)new File(folder, "variables/" + variable.getCodeString() + ".nbt"), (NBTTagCompound)out);
        }
        for (RewardTable table : this.rewardTables) {
            out = new NBTTagCompound();
            table.writeData(out);
            NBTUtils.writeNBTSafe((File)new File(folder, "reward_tables/" + table.getCodeString() + ".nbt"), (NBTTagCompound)out);
        }
    }

    public final void readDataOld(NBTTagCompound nbt) {
        this.fileVersion = nbt.func_74762_e("version");
        this.readData(nbt);
        this.chapters.clear();
        this.variables.clear();
        this.rewardTables.clear();
        Int2ObjectOpenHashMap objectDataCache = new Int2ObjectOpenHashMap();
        NBTTagList rtl = nbt.func_150295_c("reward_tables", 10);
        for (int i = 0; i < rtl.func_74745_c(); ++i) {
            RewardTable table = new RewardTable(this);
            NBTTagCompound nbt1 = rtl.func_150305_b(i);
            table.id = nbt1.func_74762_e("uid");
            this.rewardTables.add(table);
            objectDataCache.put(table.id, (Object)nbt1);
        }
        NBTTagList c = nbt.func_150295_c("chapters", 10);
        for (int i = 0; i < c.func_74745_c(); ++i) {
            QuestChapter chapter = new QuestChapter(this);
            NBTTagCompound ct = c.func_150305_b(i);
            chapter.id = ct.func_74762_e("uid");
            this.chapters.add(chapter);
            objectDataCache.put(chapter.id, (Object)ct);
            NBTTagList q = ct.func_150295_c("quests", 10);
            for (int j = 0; j < q.func_74745_c(); ++j) {
                NBTBase rt;
                NBTBase tt;
                Quest quest = new Quest(chapter);
                NBTTagCompound qt = q.func_150305_b(j);
                quest.id = qt.func_74762_e("uid");
                chapter.quests.add(quest);
                objectDataCache.put(quest.id, (Object)qt);
                NBTTagList t = qt.func_150295_c("tasks", 10);
                if (t.func_82582_d() && (tt = qt.func_74781_a("task")) != null) {
                    t.func_74742_a(tt);
                }
                for (int k = 0; k < t.func_74745_c(); ++k) {
                    NBTTagCompound tt2 = t.func_150305_b(k);
                    QuestTask task = QuestTaskType.createTask(quest, tt2.func_74779_i("type"));
                    if (task == null) continue;
                    task.id = tt2.func_74762_e("uid");
                    objectDataCache.put(task.id, (Object)tt2);
                    quest.tasks.add(task);
                }
                NBTTagList r = qt.func_150295_c("rewards", 10);
                if (r.func_82582_d() && (rt = qt.func_74781_a("reward")) != null) {
                    r.func_74742_a(rt);
                }
                for (int k = 0; k < r.func_74745_c(); ++k) {
                    NBTTagCompound rt2 = r.func_150305_b(k);
                    QuestReward reward = QuestRewardType.createReward(quest, rt2.func_74779_i("type"));
                    if (reward == null) continue;
                    reward.id = rt2.func_74762_e("uid");
                    objectDataCache.put(reward.id, (Object)rt2);
                    quest.rewards.add(reward);
                }
            }
        }
        NBTTagList v = nbt.func_150295_c("variables", 10);
        for (int i = 0; i < v.func_74745_c(); ++i) {
            QuestVariable variable = new QuestVariable(this);
            NBTTagCompound nbt1 = v.func_150305_b(i);
            variable.id = nbt1.func_74762_e("uid");
            objectDataCache.put(variable.id, (Object)nbt1);
            this.variables.add(variable);
        }
        this.refreshIDMap();
        for (QuestChapter chapter : this.chapters) {
            NBTTagCompound nbt1 = (NBTTagCompound)objectDataCache.get(chapter.id);
            if (nbt1 != null) {
                chapter.readData(nbt1);
            }
            for (Quest quest : chapter.quests) {
                nbt1 = (NBTTagCompound)objectDataCache.get(quest.id);
                if (nbt1 != null) {
                    quest.readData(nbt1);
                }
                for (QuestTask task : quest.tasks) {
                    nbt1 = (NBTTagCompound)objectDataCache.get(task.id);
                    if (nbt1 == null) continue;
                    task.readData(nbt1);
                }
                for (QuestReward reward : quest.rewards) {
                    nbt1 = (NBTTagCompound)objectDataCache.get(reward.id);
                    if (nbt1 == null) continue;
                    reward.readData(nbt1);
                }
            }
        }
        for (QuestVariable variable : this.variables) {
            NBTTagCompound nbt1 = (NBTTagCompound)objectDataCache.get(variable.id);
            if (nbt1 == null) continue;
            variable.readData(nbt1);
        }
        for (RewardTable table : this.rewardTables) {
            NBTTagCompound nbt1 = (NBTTagCompound)objectDataCache.get(table.id);
            if (nbt1 == null) continue;
            table.readData(nbt1);
        }
        for (QuestChapter chapter : this.chapters) {
            for (Quest quest : chapter.quests) {
                quest.verifyDependencies(true);
            }
        }
    }

    public final void readDataFull(File folder) {
        NBTTagCompound nbt = NBTUtils.readNBT((File)new File(folder, "file.nbt"));
        if (nbt != null) {
            this.fileVersion = nbt.func_74762_e("version");
            this.readData(nbt);
        }
        this.chapters.clear();
        this.variables.clear();
        this.rewardTables.clear();
        Int2ObjectOpenHashMap questFileCache = new Int2ObjectOpenHashMap();
        for (int i : this.readIndex(new File(folder, "chapters/index.nbt"))) {
            QuestChapter chapter = new QuestChapter(this);
            chapter.id = i;
            this.chapters.add(chapter);
            File[] files = new File(folder, "chapters/" + chapter.getCodeString()).listFiles();
            if (files == null || files.length <= 0) continue;
            for (File f : files) {
                if (f.getName().equals("chapter.nbt")) continue;
                try {
                    Quest quest = new Quest(chapter);
                    quest.id = Long.decode("#" + f.getName().replace(".nbt", "")).intValue();
                    nbt = NBTUtils.readNBT((File)new File(folder, "chapters/" + chapter.getCodeString() + "/" + quest.getCodeString() + ".nbt"));
                    if (nbt == null) continue;
                    questFileCache.put(quest.id, (Object)nbt);
                    NBTTagList t = nbt.func_150295_c("tasks", 10);
                    for (int k = 0; k < t.func_74745_c(); ++k) {
                        NBTTagCompound tt = t.func_150305_b(k);
                        QuestTask task = QuestTaskType.createTask(quest, tt.func_74779_i("type"));
                        if (task == null) continue;
                        task.id = tt.func_74762_e("uid");
                        quest.tasks.add(task);
                    }
                    NBTTagList r = nbt.func_150295_c("rewards", 10);
                    for (int k = 0; k < r.func_74745_c(); ++k) {
                        NBTTagCompound rt = r.func_150305_b(k);
                        QuestReward reward = QuestRewardType.createReward(quest, rt.func_74779_i("type"));
                        if (reward == null) continue;
                        reward.id = rt.func_74762_e("uid");
                        quest.rewards.add(reward);
                    }
                    chapter.quests.add(quest);
                }
                catch (Exception ex) {
                    FTBQuests.LOGGER.warn("Failed to read quest ID " + f.getName());
                }
            }
        }
        for (int i : this.readIndex(new File(folder, "variables/index.nbt"))) {
            QuestVariable variable = new QuestVariable(this);
            variable.id = i;
            this.variables.add(variable);
        }
        for (int i : this.readIndex(new File(folder, "reward_tables/index.nbt"))) {
            RewardTable table = new RewardTable(this);
            table.id = i;
            this.rewardTables.add(table);
        }
        this.refreshIDMap();
        Object object = this.chapters.iterator();
        while (object.hasNext()) {
            QuestChapter chapter = (QuestChapter)object.next();
            nbt = NBTUtils.readNBT((File)new File(folder, "chapters/" + chapter.getCodeString() + "/chapter.nbt"));
            if (nbt != null) {
                chapter.readData(nbt);
            }
            for (Quest quest : chapter.quests) {
                nbt = (NBTTagCompound)questFileCache.get(quest.id);
                if (nbt == null) continue;
                quest.readData(nbt);
                NBTTagList t = nbt.func_150295_c("tasks", 10);
                for (int k = 0; k < t.func_74745_c(); ++k) {
                    NBTTagCompound tt = t.func_150305_b(k);
                    QuestTask task = this.getTask(tt.func_74762_e("uid"));
                    if (task == null) continue;
                    task.readData(tt);
                }
                NBTTagList r = nbt.func_150295_c("rewards", 10);
                for (int k = 0; k < r.func_74745_c(); ++k) {
                    NBTTagCompound rt = r.func_150305_b(k);
                    QuestReward reward = this.getReward(rt.func_74762_e("uid"));
                    if (reward == null) continue;
                    reward.readData(rt);
                }
            }
        }
        for (QuestVariable variable : this.variables) {
            nbt = NBTUtils.readNBT((File)new File(folder, "variables/" + variable.getCodeString() + ".nbt"));
            if (nbt == null) continue;
            variable.readData(nbt);
        }
        for (RewardTable table : this.rewardTables) {
            nbt = NBTUtils.readNBT((File)new File(folder, "reward_tables/" + table.getCodeString() + ".nbt"));
            if (nbt == null) continue;
            table.readData(nbt);
        }
        for (QuestChapter chapter : this.chapters) {
            for (Quest quest : chapter.quests) {
                quest.verifyDependencies(true);
            }
        }
    }

    @Override
    public final void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeCollection(this.emergencyItems, DataOut.ITEM_STACK);
        data.writeVarLong(this.emergencyItemsCooldown.ticks());
        data.writeBoolean(this.defaultRewardTeam);
        data.writeBoolean(this.defaultTeamConsumeItems);
        data.writeBoolean(this.defaultRewardAutoclaim);
        data.write((Object)this.defaultShape, EnumQuestShape.NAME_MAP);
        data.writeBoolean(this.dropLootCrates);
        this.lootCrateNoDrop.writeNetData(data);
        data.writeBoolean(this.disableGui);
    }

    @Override
    public final void readNetData(DataIn data) {
        super.readNetData(data);
        data.readCollection(this.emergencyItems, DataIn.ITEM_STACK);
        this.emergencyItemsCooldown = Ticks.get((long)data.readVarLong());
        this.defaultRewardTeam = data.readBoolean();
        this.defaultTeamConsumeItems = data.readBoolean();
        this.defaultRewardAutoclaim = data.readBoolean();
        this.defaultShape = (EnumQuestShape)((Object)data.read(EnumQuestShape.NAME_MAP));
        this.dropLootCrates = data.readBoolean();
        this.lootCrateNoDrop.readNetData(data);
        this.disableGui = data.readBoolean();
    }

    public final void writeNetDataFull(DataOut data) {
        int pos = data.getPosition();
        this.writeNetData(data);
        data.writeVarInt(this.rewardTables.size());
        for (RewardTable table : this.rewardTables) {
            data.writeInt(table.id);
        }
        data.writeVarInt(this.chapters.size());
        ForgeRegistry<QuestTaskType> taskTypes = QuestTaskType.getRegistry();
        ForgeRegistry<QuestRewardType> rewardTypes = QuestRewardType.getRegistry();
        for (QuestChapter chapter : this.chapters) {
            data.writeInt(chapter.id);
            data.writeVarInt(chapter.quests.size());
            for (Quest quest : chapter.quests) {
                data.writeInt(quest.id);
                data.writeVarInt(quest.tasks.size());
                for (QuestTask task : quest.tasks) {
                    data.writeVarInt(taskTypes.getID((IForgeRegistryEntry)task.getType()));
                    data.writeInt(task.id);
                }
                data.writeVarInt(quest.rewards.size());
                for (QuestReward reward : quest.rewards) {
                    data.writeVarInt(rewardTypes.getID((IForgeRegistryEntry)reward.getType()));
                    data.writeInt(reward.id);
                }
            }
        }
        data.writeVarInt(this.variables.size());
        for (QuestVariable variable : this.variables) {
            data.writeInt(variable.id);
        }
        for (RewardTable table : this.rewardTables) {
            table.writeNetData(data);
        }
        for (QuestChapter chapter : this.chapters) {
            chapter.writeNetData(data);
            for (Quest quest : chapter.quests) {
                quest.writeNetData(data);
                for (QuestTask task : quest.tasks) {
                    task.writeNetData(data);
                }
                for (QuestReward reward : quest.rewards) {
                    reward.writeNetData(data);
                }
            }
        }
        for (QuestVariable variable : this.variables) {
            variable.writeNetData(data);
        }
        if (FTBLibConfig.debugging.print_more_info) {
            FTBQuests.LOGGER.info("Wrote " + (data.getPosition() - pos) + " bytes");
        }
    }

    public final void readNetDataFull(DataIn data) {
        int pos = data.getPosition();
        this.readNetData(data);
        this.chapters.clear();
        this.variables.clear();
        this.rewardTables.clear();
        int rtl = data.readVarInt();
        for (int i = 0; i < rtl; ++i) {
            RewardTable table = new RewardTable(this);
            table.id = data.readInt();
            this.rewardTables.add(table);
        }
        ForgeRegistry<QuestTaskType> taskTypes = QuestTaskType.getRegistry();
        ForgeRegistry<QuestRewardType> rewardTypes = QuestRewardType.getRegistry();
        int c = data.readVarInt();
        for (int i = 0; i < c; ++i) {
            QuestChapter chapter = new QuestChapter(this);
            chapter.id = data.readInt();
            this.chapters.add(chapter);
            int q = data.readVarInt();
            for (int j = 0; j < q; ++j) {
                Quest quest = new Quest(chapter);
                quest.id = data.readInt();
                chapter.quests.add(quest);
                int t = data.readVarInt();
                for (int k = 0; k < t; ++k) {
                    QuestTaskType type = (QuestTaskType)taskTypes.getValue(data.readVarInt());
                    QuestTask task = type.provider.create(quest);
                    task.id = data.readInt();
                    quest.tasks.add(task);
                }
                int r = data.readVarInt();
                for (int k = 0; k < r; ++k) {
                    QuestRewardType type = (QuestRewardType)rewardTypes.getValue(data.readVarInt());
                    QuestReward reward = type.provider.create(quest);
                    reward.id = data.readInt();
                    quest.rewards.add(reward);
                }
            }
        }
        int v = data.readVarInt();
        for (int i = 0; i < v; ++i) {
            QuestVariable variable = new QuestVariable(this);
            variable.id = data.readInt();
            this.variables.add(variable);
        }
        this.refreshIDMap();
        for (RewardTable table : this.rewardTables) {
            table.readNetData(data);
        }
        for (QuestChapter chapter : this.chapters) {
            chapter.readNetData(data);
            for (Quest quest : chapter.quests) {
                quest.readNetData(data);
                for (QuestTask task : quest.tasks) {
                    task.readNetData(data);
                }
                for (QuestReward reward : quest.rewards) {
                    reward.readNetData(data);
                }
            }
        }
        for (QuestVariable variable : this.variables) {
            variable.readNetData(data);
        }
        if (FTBLibConfig.debugging.print_more_info) {
            FTBQuests.LOGGER.info("Read " + (data.getPosition() - pos) + " bytes");
        }
    }

    @Nullable
    public abstract ITeamData getData(short var1);

    @Nullable
    public abstract ITeamData getData(String var1);

    @Nullable
    public final ITeamData getData(EntityPlayer player) {
        return this.getData(FTBLibAPI.getTeamID((UUID)player.func_110124_au()));
    }

    public abstract Collection<? extends ITeamData> getAllData();

    public abstract void deleteObject(int var1);

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (QuestChapter chapter : this.chapters) {
            list.add(chapter.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.file", (Object[])new Object[0]);
    }

    @Override
    public void getConfig(EntityPlayer player, ConfigGroup config) {
        super.getConfig(player, config);
        config.addList("emergency_items", this.emergencyItems, (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a), ConfigItemStack::new, ConfigItemStack::getStack);
        config.add("emergency_items_cooldown", (ConfigValue)new ConfigTimer(Ticks.NO_TICKS){

            public Ticks getTimer() {
                return QuestFile.this.emergencyItemsCooldown;
            }

            public void setTimer(Ticks t) {
                QuestFile.this.emergencyItemsCooldown = t;
            }
        }, (ConfigValue)new ConfigTimer(Ticks.MINUTE.x(5L)));
        config.addBool("drop_loot_crates", () -> this.dropLootCrates, v -> {
            this.dropLootCrates = v;
        }, false);
        config.addBool("disable_gui", () -> this.disableGui, v -> {
            this.disableGui = v;
        }, false);
        ConfigGroup defaultsGroup = config.getGroup("defaults");
        defaultsGroup.addBool("reward_team", () -> this.defaultRewardTeam, v -> {
            this.defaultRewardTeam = v;
        }, false);
        defaultsGroup.addBool("consume_items", () -> this.defaultTeamConsumeItems, v -> {
            this.defaultTeamConsumeItems = v;
        }, false);
        defaultsGroup.addBool("autoclaim_rewards", () -> this.defaultRewardAutoclaim, v -> {
            this.defaultRewardAutoclaim = v;
        }, false);
        defaultsGroup.addEnum("quest_shape", () -> this.defaultShape, v -> {
            this.defaultShape = v;
        }, EnumQuestShape.NAME_MAP.withDefault((Object)EnumQuestShape.CIRCLE));
        ConfigGroup d = config.getGroup("loot_crate_no_drop");
        d.addInt("passive", () -> this.lootCrateNoDrop.passive, v -> {
            this.lootCrateNoDrop.passive = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.loot.entitytype.passive", new Object[0]));
        d.addInt("monster", () -> this.lootCrateNoDrop.monster, v -> {
            this.lootCrateNoDrop.monster = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.loot.entitytype.monster", new Object[0]));
        d.addInt("boss", () -> this.lootCrateNoDrop.boss, v -> {
            this.lootCrateNoDrop.boss = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.loot.entitytype.boss", new Object[0]));
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (QuestChapter chapter : this.chapters) {
            chapter.clearCachedData();
        }
        new ClearFileCacheEvent(this).post();
    }

    public int readID(int id) {
        while (id == 0 || id == 1 || this.map.get(id) != null) {
            id = MathUtils.RAND.nextInt();
        }
        return id;
    }

    public static int getID(String id) {
        if (id.isEmpty()) {
            return 0;
        }
        if (id.charAt(0) == '*') {
            return 1;
        }
        try {
            return Long.valueOf(id.charAt(0) == '#' ? id.substring(1) : id, 16).intValue();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Nullable
    public LootCrate getRandomLootCrate(Entity entity, Random random) {
        int totalWeight = this.lootCrateNoDrop.getWeight(entity);
        for (RewardTable table : this.rewardTables) {
            if (table.lootCrate == null) continue;
            totalWeight += table.lootCrate.drops.getWeight(entity);
        }
        if (totalWeight <= 0) {
            return null;
        }
        int number = random.nextInt(totalWeight) + 1;
        int currentWeight = this.lootCrateNoDrop.getWeight(entity);
        if (currentWeight < number) {
            for (RewardTable table : this.rewardTables) {
                if (table.lootCrate == null || (currentWeight += table.lootCrate.drops.getWeight(entity)) < number) continue;
                return table.lootCrate;
            }
        }
        return null;
    }

    @Override
    public final int refreshJEI() {
        return 255;
    }

    public final Collection<QuestObjectBase> getAllObjects() {
        return this.map.values();
    }

    @Override
    public void clearCachedProgress(short id) {
        super.clearCachedProgress(id);
        for (QuestChapter chapter : this.chapters) {
            chapter.clearCachedProgress(id);
            for (Quest quest : chapter.quests) {
                quest.clearCachedProgress(id);
                for (QuestTask task : quest.tasks) {
                    task.clearCachedProgress(id);
                }
            }
        }
        for (QuestVariable variable : this.variables) {
            variable.clearCachedProgress(id);
        }
    }

    public int getUnclaimedRewards(UUID player, ITeamData data, boolean showExcluded) {
        int r = 0;
        for (QuestChapter chapter : this.chapters) {
            for (Quest quest : chapter.quests) {
                r += quest.getUnclaimedRewards(player, data, showExcluded);
            }
        }
        return r;
    }

    @Override
    public boolean isVisible(ITeamData data) {
        for (QuestChapter chapter : this.chapters) {
            if (!chapter.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    public List<QuestChapter> getVisibleChapters(ITeamData data, boolean excludeEmpty) {
        ArrayList<QuestChapter> list = new ArrayList<QuestChapter>();
        for (QuestChapter chapter : this.chapters) {
            if (excludeEmpty && chapter.quests.isEmpty() || !chapter.isVisible(data)) continue;
            list.add(chapter);
        }
        return list;
    }
}

