/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.ListUtils;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public final class QuestChapter
extends QuestObject {
    public final QuestFile file;
    public final List<Quest> quests;
    public final List<String> description;
    public boolean alwaysInvisible;
    public QuestChapter group;

    public QuestChapter(QuestFile f) {
        this.file = f;
        this.description = new ArrayList<String>(0);
        this.quests = new ArrayList<Quest>();
        this.alwaysInvisible = false;
        this.group = null;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.CHAPTER;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    @Override
    public QuestChapter getQuestChapter() {
        return this;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (!this.description.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (String v : this.description) {
                list.func_74742_a((NBTBase)new NBTTagString(v));
            }
            nbt.func_74782_a("description", (NBTBase)list);
        }
        if (this.alwaysInvisible) {
            nbt.func_74757_a("always_invisible", true);
        }
        if (this.group != null && !this.group.invalid) {
            nbt.func_74768_a("group", this.group.id);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.description.clear();
        NBTTagList desc = nbt.func_150295_c("description", 8);
        for (int i = 0; i < desc.func_74745_c(); ++i) {
            this.description.add(desc.func_150307_f(i));
        }
        this.alwaysInvisible = nbt.func_74767_n("always_invisible");
        this.group = this.file.getChapter(nbt.func_74762_e("group"));
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeCollection(this.description, DataOut.STRING);
        data.writeBoolean(this.alwaysInvisible);
        data.writeInt(this.group == null || this.group.invalid ? 0 : this.group.id);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        data.readCollection(this.description, DataIn.STRING);
        this.alwaysInvisible = data.readBoolean();
        this.group = this.file.getChapter(data.readInt());
    }

    public int getIndex() {
        return this.file.chapters.indexOf(this);
    }

    @Override
    public int getRelativeProgressFromChildren(ITeamData data) {
        int progress = 0;
        for (Quest quest : this.quests) {
            if (quest.canRepeat) continue;
            progress += quest.getRelativeProgress(data);
        }
        return QuestChapter.getRelativeProgressFromChildren(progress, this.quests.size());
    }

    @Override
    public void onCompleted(ITeamData data, List<EntityPlayerMP> notifyPlayers) {
        super.onCompleted(data, notifyPlayers);
        new ObjectCompletedEvent.ChapterEvent(data, this).post();
        for (EntityPlayerMP player : notifyPlayers) {
            new MessageDisplayCompletionToast(this.id).sendTo(player);
        }
        if (this.file.isComplete(data)) {
            this.file.onCompleted(data, notifyPlayers);
        }
    }

    @Override
    public void changeProgress(ITeamData data, EnumChangeProgress type) {
        for (Quest quest : this.quests) {
            quest.changeProgress(data, type);
        }
        for (QuestChapter chapter : this.getChildren()) {
            chapter.changeProgress(data, type);
        }
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Quest quest : this.quests) {
            list.add(quest.getIcon());
        }
        for (QuestChapter child : this.getChildren()) {
            list.add(child.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.unnamed", (Object[])new Object[0]);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.file.chapters.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (Quest quest : this.quests) {
            quest.deleteChildren();
            quest.invalid = true;
        }
        this.quests.clear();
    }

    @Override
    public void onCreated() {
        this.file.chapters.add(this);
        if (!this.quests.isEmpty()) {
            for (Quest quest : ListUtils.clearAndCopy(this.quests)) {
                quest.onCreated();
            }
        }
    }

    @Override
    public File getFile(File folder) {
        return new File(folder, "chapters/" + this.getCodeString());
    }

    @Override
    public void getConfig(EntityPlayer player, ConfigGroup config) {
        super.getConfig(player, config);
        config.addList("description", this.description, (ConfigValue)new ConfigString(""), ConfigString::new, ConfigString::getString);
        config.addBool("always_invisible", () -> this.alwaysInvisible, v -> {
            this.alwaysInvisible = v;
        }, false);
        Predicate<QuestObjectBase> predicate = object -> object == null || object instanceof QuestChapter && object != this && ((QuestChapter)object).group == null;
        config.add("group", (ConfigValue)new ConfigQuestObject(this.file, this.group, predicate){

            @Override
            @Nullable
            public QuestObjectBase getObject() {
                return QuestChapter.this.group;
            }

            @Override
            public void setObject(@Nullable QuestObjectBase v) {
                QuestChapter.this.group = (QuestChapter)v;
            }
        }, (ConfigValue)new ConfigQuestObject(this.file, null, predicate));
    }

    @Override
    public boolean isVisible(ITeamData data) {
        if (this.alwaysInvisible) {
            return false;
        }
        for (Quest quest : this.quests) {
            if (!quest.isVisible(data)) continue;
            return true;
        }
        for (QuestChapter child : this.getChildren()) {
            if (!child.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (Quest quest : this.quests) {
            quest.clearCachedData();
        }
        for (QuestChapter chapter : this.getChildren()) {
            chapter.clearCachedData();
        }
    }

    public boolean hasChildren() {
        if (this.group != null) {
            return false;
        }
        for (QuestChapter chapter : this.file.chapters) {
            if (chapter.group != this) continue;
            return true;
        }
        return false;
    }

    public List<QuestChapter> getChildren() {
        List<QuestChapter> list = Collections.emptyList();
        if (this.group != null) {
            return list;
        }
        for (QuestChapter chapter : this.file.chapters) {
            if (chapter.group != this) continue;
            if (list.isEmpty()) {
                list = new ArrayList<QuestChapter>(3);
            }
            list.add(chapter);
        }
        return list;
    }

    public boolean hasUnclaimedRewards(UUID player, ITeamData data, boolean showExcluded) {
        for (Quest quest : this.quests) {
            if (!quest.hasUnclaimedRewards(player, data, showExcluded)) continue;
            return true;
        }
        for (QuestChapter chapter : this.getChildren()) {
            if (!chapter.hasUnclaimedRewards(player, data, showExcluded)) continue;
            return true;
        }
        return false;
    }

    public int getUnclaimedRewards(UUID player, ITeamData data, boolean showExcluded) {
        int r = 0;
        for (Quest quest : this.quests) {
            r += quest.getUnclaimedRewards(player, data, showExcluded);
        }
        for (QuestChapter chapter : this.getChildren()) {
            r += chapter.getUnclaimedRewards(player, data, showExcluded);
        }
        return r;
    }

    @Override
    public boolean verifyDependenciesInternal(QuestObject original, boolean firstLoop) {
        if (this == original && !firstLoop) {
            return false;
        }
        for (Quest quest : this.quests) {
            if (quest.verifyDependenciesInternal(original, false)) continue;
            return false;
        }
        return true;
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.invalid;
    }
}

