/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.ListUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.EnumDependencyRequirement;
import com.feed_the_beast.ftbquests.quest.EnumQuestShape;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public final class Quest
extends QuestObject {
    public static final int POS_LIMIT = 25;
    public final QuestChapter chapter;
    public String description;
    public byte x;
    public byte y;
    public boolean hide;
    public EnumQuestShape shape;
    public final List<String> text;
    public final List<QuestObject> dependencies;
    public boolean canRepeat;
    public final List<QuestTask> tasks;
    public final List<QuestReward> rewards;
    public EnumDependencyRequirement dependencyRequirement;
    public String guidePage;
    public String customClick;
    public boolean hideDependencyLines;
    public int minRequiredDependencies;
    public boolean hideTextUntilComplete;
    private String cachedDescription = null;
    private String[] cachedText = null;

    public Quest(QuestChapter c) {
        this.chapter = c;
        this.description = "";
        this.x = 0;
        this.y = 0;
        this.shape = this.chapter.file.defaultShape;
        this.text = new ArrayList<String>();
        this.canRepeat = false;
        this.dependencies = new ArrayList<QuestObject>(0);
        this.tasks = new ArrayList<QuestTask>(1);
        this.rewards = new ArrayList<QuestReward>(1);
        this.guidePage = "";
        this.customClick = "";
        this.hideDependencyLines = false;
        this.hide = false;
        this.dependencyRequirement = EnumDependencyRequirement.ALL_COMPLETED;
        this.minRequiredDependencies = 0;
        this.hideTextUntilComplete = false;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.QUEST;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.chapter.file;
    }

    @Override
    public QuestChapter getQuestChapter() {
        return this.chapter;
    }

    @Override
    public int getParentID() {
        return this.chapter.id;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.x != 0) {
            nbt.func_74774_a("x", this.x);
        }
        if (this.y != 0) {
            nbt.func_74774_a("y", this.y);
        }
        if (this.shape != this.chapter.file.defaultShape) {
            nbt.func_74778_a("shape", this.shape.getID());
        }
        if (!this.description.isEmpty()) {
            nbt.func_74778_a("description", this.description);
        }
        if (!this.text.isEmpty()) {
            NBTTagList array = new NBTTagList();
            for (String value : this.text) {
                array.func_74742_a((NBTBase)new NBTTagString(value));
            }
            nbt.func_74782_a("text", (NBTBase)array);
        }
        if (this.canRepeat) {
            nbt.func_74757_a("can_repeat", true);
        }
        if (!this.guidePage.isEmpty()) {
            nbt.func_74778_a("guide_page", this.guidePage);
        }
        if (!this.customClick.isEmpty()) {
            nbt.func_74778_a("custom_click", this.customClick);
        }
        if (this.hideDependencyLines) {
            nbt.func_74757_a("hide_dependency_lines", true);
        }
        if (this.minRequiredDependencies > 0) {
            nbt.func_74768_a("min_required_dependencies", (int)((byte)this.minRequiredDependencies));
        }
        this.removeInvalidDependencies();
        if (!this.dependencies.isEmpty()) {
            int[] ai = new int[this.dependencies.size()];
            for (int i = 0; i < this.dependencies.size(); ++i) {
                ai[i] = this.dependencies.get((int)i).id;
            }
            if (ai.length == 1) {
                nbt.func_74768_a("dependency", ai[0]);
            } else {
                nbt.func_74783_a("dependencies", ai);
            }
        }
        if (this.hide) {
            nbt.func_74757_a("hide", true);
        }
        if (this.dependencyRequirement != EnumDependencyRequirement.ALL_COMPLETED) {
            nbt.func_74778_a("dependency_requirement", this.dependencyRequirement.getID());
        }
        if (this.hideTextUntilComplete) {
            nbt.func_74757_a("hide_text_until_complete", true);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.description = nbt.func_74779_i("description");
        this.x = (byte)MathHelper.func_76125_a((int)nbt.func_74771_c("x"), (int)-25, (int)25);
        this.y = (byte)MathHelper.func_76125_a((int)nbt.func_74771_c("y"), (int)-25, (int)25);
        this.shape = nbt.func_74764_b("shape") ? (EnumQuestShape)((Object)EnumQuestShape.NAME_MAP.get(nbt.func_74779_i("shape"))) : this.chapter.file.defaultShape;
        this.text.clear();
        NBTTagList list = nbt.func_150295_c("text", 8);
        for (int k = 0; k < list.func_74745_c(); ++k) {
            this.text.add(list.func_150307_f(k));
        }
        this.canRepeat = nbt.func_74767_n("can_repeat");
        this.guidePage = nbt.func_74779_i("guide_page");
        this.customClick = nbt.func_74779_i("custom_click");
        this.hideDependencyLines = nbt.func_74767_n("hide_dependency_lines");
        this.minRequiredDependencies = nbt.func_74762_e("min_required_dependencies");
        this.dependencies.clear();
        NBTBase depsTag = nbt.func_74781_a("dependencies");
        if (depsTag instanceof NBTTagIntArray) {
            for (int i : nbt.func_74759_k("dependencies")) {
                QuestObject object = this.chapter.file.get(i);
                if (object == null) continue;
                this.dependencies.add(object);
            }
        } else if (depsTag instanceof NBTTagList) {
            list = (NBTTagList)depsTag;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt1 = list.func_150305_b(i);
                QuestObject object = this.chapter.file.get(nbt1.func_74762_e("id"));
                if (object == null) continue;
                this.dependencies.add(object);
            }
        } else {
            QuestObject object = this.chapter.file.get(nbt.func_74762_e("dependency"));
            if (object != null) {
                this.dependencies.add(object);
            }
        }
        this.hide = nbt.func_74767_n("hide");
        this.dependencyRequirement = (EnumDependencyRequirement)((Object)EnumDependencyRequirement.NAME_MAP.get(nbt.func_74779_i("dependency_requirement")));
        this.hideTextUntilComplete = nbt.func_74767_n("hide_text_until_complete");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.canRepeat);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.hide);
        flags = Bits.setFlag((int)flags, (int)4, (!this.guidePage.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (!this.description.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)16, (!this.text.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)32, (!this.customClick.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)64, (boolean)this.hideDependencyLines);
        flags = Bits.setFlag((int)flags, (int)128, (boolean)this.hideTextUntilComplete);
        data.writeVarInt(flags);
        if (!this.description.isEmpty()) {
            data.writeString(this.description);
        }
        data.writeByte((int)this.x);
        data.writeByte((int)this.y);
        data.write((Object)this.shape, EnumQuestShape.NAME_MAP);
        if (!this.text.isEmpty()) {
            data.writeCollection(this.text, DataOut.STRING);
        }
        if (!this.guidePage.isEmpty()) {
            data.writeString(this.guidePage);
        }
        if (!this.customClick.isEmpty()) {
            data.writeString(this.customClick);
        }
        data.writeVarInt(this.minRequiredDependencies);
        EnumDependencyRequirement.NAME_MAP.write(data, (Object)this.dependencyRequirement);
        data.writeVarInt(this.dependencies.size());
        for (QuestObject d : this.dependencies) {
            if (d.invalid) {
                data.writeInt(0);
                continue;
            }
            data.writeInt(d.id);
        }
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        int flags = data.readVarInt();
        this.description = Bits.getFlag((int)flags, (int)8) ? data.readString() : "";
        this.x = data.readByte();
        this.y = data.readByte();
        this.shape = (EnumQuestShape)((Object)data.read(EnumQuestShape.NAME_MAP));
        if (Bits.getFlag((int)flags, (int)16)) {
            data.readCollection(this.text, DataIn.STRING);
        } else {
            this.text.clear();
        }
        this.canRepeat = Bits.getFlag((int)flags, (int)1);
        this.hide = Bits.getFlag((int)flags, (int)2);
        this.guidePage = Bits.getFlag((int)flags, (int)4) ? data.readString() : "";
        this.customClick = Bits.getFlag((int)flags, (int)32) ? data.readString() : "";
        this.hideDependencyLines = Bits.getFlag((int)flags, (int)64);
        this.hideTextUntilComplete = Bits.getFlag((int)flags, (int)128);
        this.minRequiredDependencies = data.readVarInt();
        this.dependencyRequirement = (EnumDependencyRequirement)((Object)EnumDependencyRequirement.NAME_MAP.read(data));
        this.dependencies.clear();
        int d = data.readVarInt();
        for (int i = 0; i < d; ++i) {
            QuestObject object = this.chapter.file.get(data.readInt());
            if (object == null) continue;
            this.dependencies.add(object);
        }
    }

    @Override
    public int getRelativeProgressFromChildren(ITeamData data) {
        int progress = 0;
        for (QuestTask task : this.tasks) {
            progress += task.getRelativeProgress(data);
        }
        if (progress > 0 && !this.areDependenciesComplete(data)) {
            return 0;
        }
        return Quest.getRelativeProgressFromChildren(progress, this.tasks.size());
    }

    public boolean areDependenciesComplete(ITeamData data) {
        if (this.dependencies.isEmpty()) {
            return true;
        }
        if (this.minRequiredDependencies > 0) {
            int complete = 0;
            for (QuestObject dependency : this.dependencies) {
                if (dependency.invalid || !dependency.isComplete(data) || ++complete < this.minRequiredDependencies) continue;
                return true;
            }
            return false;
        }
        if (this.dependencyRequirement.one) {
            for (QuestObject object : this.dependencies) {
                if (object.invalid || !(this.dependencyRequirement.completed ? object.isComplete(data) : object.isStarted(data))) continue;
                return true;
            }
            return false;
        }
        for (QuestObject object : this.dependencies) {
            if (object.invalid || !(this.dependencyRequirement.completed ? !object.isComplete(data) : !object.isStarted(data))) continue;
            return false;
        }
        return true;
    }

    public boolean canStartTasks(ITeamData data) {
        return this.areDependenciesComplete(data);
    }

    @Override
    public void onCompleted(ITeamData data, List<EntityPlayerMP> notifyPlayers) {
        super.onCompleted(data, notifyPlayers);
        for (EntityPlayerMP player : notifyPlayers) {
            new MessageDisplayCompletionToast(this.id).sendTo(player);
        }
        data.checkAutoCompletion(this);
        new ObjectCompletedEvent.QuestEvent(data, this).post();
        if (this.chapter.isComplete(data)) {
            this.chapter.onCompleted(data, notifyPlayers);
        }
    }

    @Override
    public void changeProgress(ITeamData data, EnumChangeProgress type) {
        if (type.dependencies) {
            for (QuestObject dependency : this.dependencies) {
                if (dependency.invalid) continue;
                dependency.changeProgress(data, type);
            }
        }
        for (QuestTask task : this.tasks) {
            task.changeProgress(data, type);
        }
        if (type == EnumChangeProgress.RESET || type == EnumChangeProgress.RESET_DEPS) {
            data.unclaimRewards(this.rewards);
        }
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (QuestTask task : this.tasks) {
            list.add(task.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public String getAltTitle() {
        if (!this.tasks.isEmpty()) {
            return this.tasks.get(0).getTitle();
        }
        return I18n.func_135052_a((String)"ftbquests.unnamed", (Object[])new Object[0]);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.chapter.quests.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (QuestTask task : this.tasks) {
            task.deleteChildren();
            task.invalid = true;
        }
        for (QuestReward reward : this.rewards) {
            reward.deleteChildren();
            reward.invalid = true;
        }
        this.tasks.clear();
        this.rewards.clear();
    }

    @Override
    public void onCreated() {
        this.chapter.quests.add(this);
        if (!this.tasks.isEmpty()) {
            for (QuestTask task : ListUtils.clearAndCopy(this.tasks)) {
                task.onCreated();
            }
        }
    }

    @Override
    public File getFile(File folder) {
        return new File(folder, "chapters/" + this.chapter.getCodeString() + "/" + this.getCodeString() + ".nbt");
    }

    @Override
    public void getConfig(EntityPlayer player, ConfigGroup config) {
        super.getConfig(player, config);
        config.addInt("x", () -> this.x, v -> {
            this.x = (byte)v;
        }, 0, -25, 25);
        config.addInt("y", () -> this.y, v -> {
            this.y = (byte)v;
        }, 0, -25, 25);
        config.addBool("hide", () -> this.hide, v -> {
            this.hide = v;
        }, false);
        config.addEnum("shape", () -> this.shape, v -> {
            this.shape = v;
        }, EnumQuestShape.NAME_MAP);
        config.addString("description", () -> this.description, v -> {
            this.description = v;
        }, "");
        config.addList("text", this.text, (ConfigValue)new ConfigString(""), ConfigString::new, ConfigString::getString);
        config.addBool("can_repeat", () -> this.canRepeat, v -> {
            this.canRepeat = v;
        }, false);
        Predicate<QuestObjectBase> depTypes = object -> object != this.chapter.file && object != this.chapter && object instanceof QuestObject && !(object instanceof QuestTask);
        config.addList("dependencies", this.dependencies, (ConfigValue)new ConfigQuestObject(this.chapter.file, null, depTypes), questObject -> new ConfigQuestObject(this.chapter.file, (QuestObjectBase)questObject, depTypes), configQuestObject -> (QuestObject)configQuestObject.getObject()).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.dependencies", new Object[0]));
        config.addEnum("dependency_requirement", () -> this.dependencyRequirement, v -> {
            this.dependencyRequirement = v;
        }, EnumDependencyRequirement.NAME_MAP);
        config.addInt("min_required_dependencies", () -> this.minRequiredDependencies, v -> {
            this.minRequiredDependencies = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addBool("hide_dependency_lines", () -> this.hideDependencyLines, v -> {
            this.hideDependencyLines = v;
        }, false);
        config.addString("guide_page", () -> this.guidePage, v -> {
            this.guidePage = v;
        }, "");
        config.addString("custom_click", () -> this.customClick, v -> {
            this.customClick = v;
        }, "");
        config.addBool("hide_text_until_complete", () -> this.hideTextUntilComplete, v -> {
            this.hideTextUntilComplete = v;
        }, false);
    }

    @Override
    public boolean isVisible(ITeamData data) {
        if (this.dependencies.isEmpty()) {
            return true;
        }
        if (this.hide) {
            return this.areDependenciesComplete(data);
        }
        for (QuestObject object : this.dependencies) {
            if (!object.isVisible(data)) continue;
            return true;
        }
        return false;
    }

    public QuestTask getTask(int index) {
        if (this.tasks.isEmpty()) {
            throw new IllegalStateException("Quest has no tasks!");
        }
        if (index <= 0) {
            return this.tasks.get(0);
        }
        if (index >= this.tasks.size()) {
            return this.tasks.get(this.tasks.size() - 1);
        }
        return this.tasks.get(index);
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedDescription = null;
        this.cachedText = null;
        for (QuestTask task : this.tasks) {
            task.clearCachedData();
        }
        for (QuestReward reward : this.rewards) {
            reward.clearCachedData();
        }
    }

    public String getDescription() {
        if (this.cachedDescription != null) {
            return this.cachedDescription;
        }
        String key = String.format("quests.%08x.description", this.id);
        String t = FTBQuestsClient.addI18nAndColors(I18n.func_135052_a((String)key, (Object[])new Object[0]));
        this.cachedDescription = t.isEmpty() || key.equals(t) ? FTBQuestsClient.addI18nAndColors(this.description) : t;
        return this.cachedDescription;
    }

    public String[] getText() {
        if (this.cachedText != null) {
            return this.cachedText;
        }
        if (this.text.isEmpty()) {
            return StringUtils.EMPTY_ARRAY;
        }
        this.cachedText = new String[this.text.size()];
        for (int i = 0; i < this.cachedText.length; ++i) {
            this.cachedText[i] = FTBQuestsClient.addI18nAndColors(this.text.get(i));
        }
        return this.cachedText;
    }

    public boolean hasDependency(QuestObject object) {
        if (object.invalid) {
            return false;
        }
        for (QuestObject dependency : this.dependencies) {
            if (dependency != object) continue;
            return true;
        }
        return false;
    }

    private void removeInvalidDependencies() {
        if (!this.dependencies.isEmpty()) {
            this.dependencies.removeIf(o -> o == null || o.invalid || o == this);
        }
    }

    public boolean verifyDependencies(boolean autofix) {
        try {
            if (this.verifyDependenciesInternal(this, true)) {
                return true;
            }
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
        if (autofix) {
            FTBQuests.LOGGER.error("Looping dependencies found in " + this + "! Deleting all dependencies...");
            this.dependencies.clear();
            if (!this.chapter.file.isClient()) {
                ServerQuestFile.INSTANCE.save();
            }
        } else {
            FTBQuests.LOGGER.error("Looping dependencies found in " + this + "!");
        }
        return false;
    }

    @Override
    public boolean verifyDependenciesInternal(QuestObject original, boolean firstLoop) {
        if (this == original && !firstLoop) {
            return false;
        }
        this.removeInvalidDependencies();
        for (QuestObject dependency : this.dependencies) {
            if (dependency.verifyDependenciesInternal(original, false)) continue;
            return false;
        }
        return true;
    }

    public void checkRepeatableQuests(ITeamData data, UUID player) {
        if (!this.canRepeat) {
            return;
        }
        for (QuestReward reward1 : this.rewards) {
            if (data.isRewardClaimed(player, reward1)) continue;
            return;
        }
        this.changeProgress(data, EnumChangeProgress.RESET);
    }

    @Override
    public void editedFromGUI() {
        GuiQuestTree gui = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
        if (gui != null) {
            gui.questPanel.refreshWidgets();
            gui.viewQuestPanel.refreshWidgets();
        }
    }

    public boolean hasUnclaimedRewards(UUID player, ITeamData data, boolean showExcluded) {
        if (this.isComplete(data)) {
            for (QuestReward reward : this.rewards) {
                if (!showExcluded && !reward.getExcludeFromClaimAll() || data.isRewardClaimed(player, reward)) continue;
                return true;
            }
        }
        return false;
    }

    public int getUnclaimedRewards(UUID player, ITeamData data, boolean showExcluded) {
        int r = 0;
        if (this.isComplete(data)) {
            for (QuestReward reward : this.rewards) {
                if (!showExcluded && reward.getExcludeFromClaimAll() || data.isRewardClaimed(player, reward)) continue;
                ++r;
            }
        }
        return r;
    }
}

