/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net.edit;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToServer;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.edit.FTBQuestsEditNetHandler;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObjectResponse;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class MessageEditObjectQuick
extends MessageToServer {
    private int id;
    private String configId;
    private ConfigValue value;

    public MessageEditObjectQuick() {
    }

    public MessageEditObjectQuick(int i, String c, ConfigValue v) {
        this.id = i;
        this.configId = c;
        this.value = v;
    }

    public NetworkWrapper getWrapper() {
        return FTBQuestsEditNetHandler.EDIT;
    }

    public void writeData(DataOut data) {
        data.writeInt(this.id);
        data.writeString(this.configId);
        data.writeString(this.value.getID());
        this.value.writeData(data);
    }

    public void readData(DataIn data) {
        this.id = data.readInt();
        this.configId = data.readString();
        this.value = FTBLibAPI.createConfigValueFromId((String)data.readString());
        this.value.readData(data);
    }

    public void onMessage(EntityPlayerMP player) {
        QuestObjectBase object;
        if (FTBQuests.canEdit(player) && (object = ServerQuestFile.INSTANCE.getBase(this.id)) != null) {
            ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
            ConfigGroup g = object.createSubGroup(group);
            object.getConfig((EntityPlayer)player, g);
            ConfigValueInstance inst = g.getValueInstance(this.configId);
            if (inst != null) {
                inst.getValue().setValueFromOtherValue(this.value);
                ServerQuestFile.INSTANCE.clearCachedData();
                ServerQuestFile.INSTANCE.save();
                new MessageEditObjectResponse(object).sendToAll();
            }
        }
    }
}

