/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.gamestages;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class GameStageReward
extends QuestReward {
    public String stage = "";
    public boolean silent = false;

    public GameStageReward(Quest quest) {
        super(quest);
    }

    @Override
    public QuestRewardType getType() {
        return FTBQuestsRewards.GAMESTAGE;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("stage", this.stage);
        if (this.silent) {
            nbt.func_74757_a("silent", this.silent);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.stage = nbt.func_74779_i("stage");
        this.silent = nbt.func_74767_n("silent");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.stage);
        data.writeBoolean(this.silent);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.stage = data.readString();
        this.silent = data.readBoolean();
    }

    @Override
    public void getConfig(EntityPlayer player, ConfigGroup config) {
        super.getConfig(player, config);
        config.addString("stage", () -> this.stage, v -> {
            this.stage = v;
        }, "").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbquests.gamestage", new Object[0]));
        config.addBool("silent", () -> this.silent, v -> {
            this.silent = v;
        }, false);
    }

    @Override
    public void claim(EntityPlayerMP player) {
        GameStageHelper.addStage((EntityPlayer)player, (String)this.stage);
        if (!this.silent) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.gamestage.add.target", new Object[]{this.stage}));
        }
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.reward.ftbquests.gamestage", (Object[])new Object[0]) + ": " + TextFormatting.YELLOW + this.stage;
    }
}

