/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.BlankPanel;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ColorWidget;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.TextField;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WidgetVerticalSpace;
import com.feed_the_beast.ftblib.lib.gui.misc.CompactGridLayout;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringJoiner;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.tree.ButtonAddReward;
import com.feed_the_beast.ftbquests.gui.tree.ButtonAddTask;
import com.feed_the_beast.ftbquests.gui.tree.ButtonCloseViewQuest;
import com.feed_the_beast.ftbquests.gui.tree.ButtonOpenInGuide;
import com.feed_the_beast.ftbquests.gui.tree.ButtonReward;
import com.feed_the_beast.ftbquests.gui.tree.ButtonTask;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.gui.tree.TextFieldDisabledButton;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class PanelViewQuest
extends Panel {
    public final GuiQuestTree gui;
    public Quest quest = null;
    public boolean hidePanel = false;
    private String title = "";
    private Icon icon = Icon.EMPTY;
    public Button buttonClose;
    public BlankPanel panelContent;
    public BlankPanel panelTasks;
    public BlankPanel panelRewards;
    public BlankPanel panelText;

    public PanelViewQuest(GuiQuestTree g) {
        super((Panel)g);
        this.gui = g;
        this.setPosAndSize(-1, -1, 0, 0);
        this.setOnlyRenderWidgetsInside(true);
        this.setOnlyInteractWithWidgetsInside(true);
    }

    public void addWidgets() {
        boolean showText;
        this.setPosAndSize(-1, -1, 1, 1);
        if (this.quest == null || this.hidePanel) {
            return;
        }
        this.setScrollX(0);
        this.setScrollY(0);
        this.title = TextFormatting.GRAY + this.quest.getTitle();
        this.icon = this.quest.getIcon();
        int w = Math.max(200, this.gui.getTheme().getStringWidth(this.title) + 30);
        this.panelContent = new BlankPanel((Panel)this, "ContentPanel");
        this.add((Widget)this.panelContent);
        this.panelTasks = new BlankPanel((Panel)this.panelContent, "TasksPanel");
        this.panelContent.add((Widget)this.panelTasks);
        this.panelRewards = new BlankPanel((Panel)this.panelContent, "RewardsPanel");
        this.panelContent.add((Widget)this.panelRewards);
        this.panelText = new BlankPanel((Panel)this.panelContent, "TextPanel");
        this.panelContent.add((Widget)this.panelText);
        if (!this.quest.tasks.isEmpty()) {
            for (QuestTask questTask : this.quest.tasks) {
                this.panelTasks.add((Widget)new ButtonTask((Panel)this.panelTasks, questTask));
            }
        } else if (!this.gui.file.canEdit()) {
            Object noTasks = new TextFieldDisabledButton((Panel)this.panelTasks, TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.gui.no_tasks", (Object[])new Object[0]));
            noTasks.setSize(((TextFieldDisabledButton)((Object)noTasks)).width + 8, 18);
            this.panelTasks.add(noTasks);
        }
        if (!this.quest.rewards.isEmpty()) {
            for (QuestReward questReward : this.quest.rewards) {
                this.panelRewards.add((Widget)new ButtonReward((Panel)this.panelRewards, questReward));
            }
        } else if (!this.gui.file.canEdit()) {
            TextFieldDisabledButton noRewards = new TextFieldDisabledButton((Panel)this.panelRewards, TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.gui.no_rewards", (Object[])new Object[0]));
            noRewards.setSize(noRewards.width + 8, 18);
            this.panelRewards.add((Widget)noRewards);
        }
        if (this.gui.file.canEdit()) {
            this.panelTasks.add((Widget)new ButtonAddTask((Panel)this.panelTasks, this.quest));
            this.panelRewards.add((Widget)new ButtonAddReward((Panel)this.panelRewards, this.quest));
        }
        int ww = 0;
        for (Widget widget : this.panelTasks.widgets) {
            ww = Math.max(ww, widget.width);
        }
        for (Widget widget : this.panelRewards.widgets) {
            ww = Math.max(ww, widget.width);
        }
        if ((w = Math.max(w, (ww = MathHelper.func_76125_a((int)ww, (int)70, (int)140)) * 2 + 10)) % 2 == 0) {
            ++w;
        }
        this.setWidth(w);
        this.panelContent.setPosAndSize(0, 16, w, 0);
        int n = this.panelContent.width / 2;
        this.buttonClose = new ButtonCloseViewQuest(this);
        this.add((Widget)this.buttonClose);
        this.buttonClose.setPosAndSize(w - 14, 2, 12, 12);
        TextField textFieldTasks = new TextField((Panel)this.panelContent){

            public TextField resize(Theme theme) {
                return this;
            }
        };
        textFieldTasks.setPosAndSize(2, 2, n - 3, 13);
        textFieldTasks.addFlags(36);
        textFieldTasks.setText(TextFormatting.BLUE + I18n.func_135052_a((String)"ftbquests.tasks", (Object[])new Object[0]));
        this.panelContent.add((Widget)textFieldTasks);
        TextField textFieldRewards = new TextField((Panel)this.panelContent){

            public TextField resize(Theme theme) {
                return this;
            }
        };
        textFieldRewards.setPosAndSize(n + 2, 2, n - 3, 13);
        textFieldRewards.addFlags(36);
        textFieldRewards.setText(TextFormatting.GOLD + I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]));
        this.panelContent.add((Widget)textFieldRewards);
        this.panelTasks.setPosAndSize(2, 16, n - 3, 0);
        this.panelRewards.setPosAndSize(n + 2, 16, n - 3, 0);
        int at = this.panelTasks.align((WidgetLayout)new CompactGridLayout(20));
        int ar = this.panelRewards.align((WidgetLayout)new CompactGridLayout(20));
        int h = Math.max(at, ar);
        this.panelTasks.setHeight(h);
        this.panelRewards.setHeight(h);
        int tox = (this.panelTasks.width - this.panelTasks.getContentWidth()) / 2;
        int rox = (this.panelRewards.width - this.panelRewards.getContentWidth()) / 2;
        int toy = (this.panelTasks.height - this.panelTasks.getContentHeight()) / 2;
        int roy = (this.panelRewards.height - this.panelRewards.getContentHeight()) / 2;
        for (Widget widget : this.panelTasks.widgets) {
            widget.setX(widget.posX + tox);
            widget.setY(widget.posY + toy);
        }
        for (Widget widget : this.panelRewards.widgets) {
            widget.setX(widget.posX + rox);
            widget.setY(widget.posY + roy);
        }
        this.panelText.setPosAndSize(3, 16 + h + 12, this.panelContent.width - 6, 0);
        String desc = this.quest.getDescription();
        if (!desc.isEmpty()) {
            this.panelText.add((Widget)new TextField((Panel)this.panelText).addFlags(4).setMaxWidth(this.panelText.width).setSpacing(9).setText(TextFormatting.ITALIC + TextFormatting.GRAY.toString() + desc));
        }
        boolean bl = showText = !this.quest.hideTextUntilComplete || this.gui.file.self != null && this.quest.isComplete(this.gui.file.self);
        if (showText && this.quest.getText().length > 0) {
            if (!desc.isEmpty()) {
                this.panelText.add((Widget)new WidgetVerticalSpace((Panel)this.panelText, 7));
            }
            this.panelText.add((Widget)new TextField((Panel)this.panelText).setMaxWidth(this.panelText.width).setSpacing(9).setText(StringUtils.addFormatting((String)StringJoiner.with((char)'\n').joinStrings(this.quest.getText()))));
        }
        if (showText && !this.quest.guidePage.isEmpty()) {
            if (!desc.isEmpty()) {
                this.panelText.add((Widget)new WidgetVerticalSpace((Panel)this.panelText, 7));
            }
            this.panelText.add((Widget)new ButtonOpenInGuide((Panel)this.panelText, this.quest));
        }
        if (this.panelText.widgets.isEmpty()) {
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, this.gui.borderColor, null).setPosAndSize(n, 0, 1, h + 40));
            this.panelText.setHeight(0);
            this.setHeight(Math.min(this.panelContent.getContentHeight(), this.parent.height - 10));
        } else {
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, this.gui.borderColor, null).setPosAndSize(n, 0, 1, 16 + h + 6));
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, this.gui.borderColor, null).setPosAndSize(1, 16 + h + 6, this.panelContent.width - 2, 1));
            this.panelText.setHeight(this.panelText.align((WidgetLayout)new WidgetLayout.Vertical(0, 0, 1)));
            this.setHeight(Math.min(this.panelContent.getContentHeight() + 20, this.parent.height - 10));
        }
        this.setPos((this.parent.width - this.width) / 2, (this.parent.height - this.height) / 2);
        this.panelContent.setHeight(this.height - 17);
    }

    public void alignWidgets() {
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        if (this.quest != null && !this.hidePanel) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            super.draw(theme, x, y, w, h);
            GlStateManager.func_179121_F();
        }
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        Color4I.DARK_GRAY.withAlpha(120).draw(this.gui.getX(), this.gui.getY(), this.gui.width, this.gui.height);
        theme.drawContextMenuBackground(x, y, w, h);
        theme.drawString(this.title, x + w / 2, y + 4, Color4I.WHITE, 4);
        this.icon.draw(x + 2, y + 2, 12, 12);
        ((GuiQuestTree)this.getGui()).borderColor.draw(x + 1, y + 15, w - 2, 1);
    }

    public boolean mousePressed(MouseButton button) {
        return super.mousePressed(button) || this.isMouseOver();
    }
}

