/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.tree.ButtonDummyQuest;
import com.feed_the_beast.ftbquests.gui.tree.ButtonQuest;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.quest.Quest;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class PanelQuests
extends Panel {
    public static final ImageIcon DEPENDENCY = (ImageIcon)Icon.getIcon((String)"ftbquests:textures/gui/dependency.png");
    public final GuiQuestTree treeGui;

    public PanelQuests(Panel panel) {
        super(panel);
        this.treeGui = (GuiQuestTree)panel.getGui();
    }

    private int getxy(int x, int y) {
        return x + 25 << 16 | y + 25;
    }

    public void addWidgets() {
        if (this.treeGui.selectedChapter == null) {
            return;
        }
        boolean canEdit = this.treeGui.file.canEdit();
        int minX = 26;
        int minY = 26;
        int maxX = -26;
        int maxY = -26;
        IntOpenHashSet set = new IntOpenHashSet();
        for (Quest quest : this.treeGui.selectedChapter.quests) {
            if (!this.treeGui.file.canEdit() && !quest.isVisible(ClientQuestFile.INSTANCE.self)) continue;
            this.add((Widget)new ButtonQuest(this, quest));
            if (!canEdit) continue;
            minX = Math.min(minX, quest.x);
            minY = Math.min(minY, quest.y);
            maxX = Math.max(maxX, quest.x);
            maxY = Math.max(maxY, quest.y);
            set.add(this.getxy(quest.x, quest.y));
        }
        if (canEdit) {
            if (minX == 26) {
                maxY = 0;
                maxX = 0;
                minY = 0;
                minX = 0;
            }
            minX -= 20;
            maxX += 20;
            maxY += 10;
            for (int y = minY -= 10; y <= maxY; ++y) {
                for (int x = minX; x <= maxX; ++x) {
                    if (set.contains(this.getxy(x, y))) continue;
                    this.add(new ButtonDummyQuest(this, (byte)x, (byte)y));
                }
            }
        }
        this.alignWidgets();
    }

    public void alignWidgets() {
        this.treeGui.scrollWidth = 0;
        this.treeGui.scrollHeight = 0;
        int minX = 26;
        int minY = 26;
        int maxX = -26;
        int maxY = -26;
        for (Widget widget : this.widgets) {
            if (!(widget instanceof ButtonQuest)) continue;
            Quest quest = ((ButtonQuest)widget).quest;
            minX = Math.min(minX, quest.x);
            minY = Math.min(minY, quest.y);
            maxX = Math.max(maxX, quest.x);
            maxY = Math.max(maxY, quest.y);
        }
        if (minX == 26) {
            maxY = 0;
            maxX = 0;
            minY = 0;
            minX = 0;
        }
        int bsize = this.treeGui.getZoom() * 2 - 2;
        this.treeGui.scrollWidth = ((maxX += 20) - (minX -= 20) + 1) * bsize;
        this.treeGui.scrollHeight = ((maxY += 10) - (minY -= 10) + 1) * bsize;
        for (Widget widget : this.widgets) {
            byte y;
            byte x;
            if (widget instanceof ButtonQuest) {
                Quest quest = ((ButtonQuest)widget).quest;
                x = quest.x;
                y = quest.y;
            } else {
                ButtonDummyQuest button = (ButtonDummyQuest)widget;
                x = button.x;
                y = button.y;
            }
            widget.setPosAndSize((x - minX) * bsize, (y - minY) * bsize, bsize, bsize);
        }
        this.setPosAndSize(20, 1, this.treeGui.width - 40, this.treeGui.height - 2);
    }

    public void drawOffsetBackground(Theme theme, int x, int y, int w, int h) {
        Quest wquest;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        DEPENDENCY.bindTexture();
        GlStateManager.func_179103_j((int)7425);
        double moving = -((double)System.currentTimeMillis() * 0.001) % 1.0;
        double s = (double)this.treeGui.getZoom() / 8.0;
        Quest selectedQuest = this.treeGui.getViewedQuest();
        for (Widget widget : this.widgets) {
            if (!(widget instanceof ButtonQuest)) continue;
            wquest = ((ButtonQuest)widget).quest;
            if (wquest.hideDependencyLines) continue;
            boolean unavailable = this.treeGui.file.self == null || !wquest.canStartTasks(this.treeGui.file.self);
            boolean complete = !unavailable && this.treeGui.file.self != null && wquest.isComplete(this.treeGui.file.self);
            for (ButtonQuest button : ((ButtonQuest)widget).getDependencies()) {
                int a;
                int b;
                int g;
                int r;
                if (button.quest == selectedQuest || wquest == selectedQuest) continue;
                if (complete) {
                    r = 100;
                    g = 220;
                    b = 100;
                    a = 255;
                } else {
                    Color4I c = Color4I.hsb((float)((float)button.quest.id / 1000.0f), (float)0.2f, (float)(unavailable ? 0.3f : 0.8f));
                    r = c.redi();
                    g = c.greeni();
                    b = c.bluei();
                    a = 180;
                }
                double sx = (double)widget.getX() + (double)widget.width / 2.0;
                double sy = (double)widget.getY() + (double)widget.height / 2.0;
                double ex = (double)button.getX() + (double)button.width / 2.0;
                double ey = (double)button.getY() + (double)button.height / 2.0;
                double len = MathUtils.dist((double)sx, (double)sy, (double)ex, (double)ey);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)sx, (double)sy, (double)0.0);
                GlStateManager.func_179114_b((float)((float)(Math.atan2(ey - sy, ex - sx) * 180.0 / Math.PI)), (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer.func_181662_b(0.0, -s, 0.0).func_187315_a(len / s / 2.0, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(0.0, s, 0.0).func_187315_a(len / s / 2.0, 1.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b(len, s, 0.0).func_187315_a(0.0, 1.0).func_181669_b(r * 3 / 4, g * 3 / 4, b * 3 / 4, a).func_181675_d();
                buffer.func_181662_b(len, -s, 0.0).func_187315_a(0.0, 0.0).func_181669_b(r * 3 / 4, g * 3 / 4, b * 3 / 4, a).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
        }
        for (Widget widget : this.widgets) {
            if (!(widget instanceof ButtonQuest)) continue;
            wquest = ((ButtonQuest)widget).quest;
            if (wquest.hideDependencyLines) continue;
            for (ButtonQuest button : ((ButtonQuest)widget).getDependencies()) {
                int b;
                int g;
                int r;
                if (button.quest == selectedQuest) {
                    r = 200;
                    g = 200;
                    b = 0;
                } else {
                    if (wquest != selectedQuest) continue;
                    r = 0;
                    g = 200;
                    b = 200;
                }
                double sx = (double)widget.getX() + (double)widget.width / 2.0;
                double sy = (double)widget.getY() + (double)widget.height / 2.0;
                double ex = (double)button.getX() + (double)button.width / 2.0;
                double ey = (double)button.getY() + (double)button.height / 2.0;
                double len = MathUtils.dist((double)sx, (double)sy, (double)ex, (double)ey);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)sx, (double)sy, (double)0.0);
                GlStateManager.func_179114_b((float)((float)(Math.atan2(ey - sy, ex - sx) * 180.0 / Math.PI)), (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                buffer.func_181662_b(0.0, -s, 0.0).func_187315_a(len / s / 2.0 + moving, 0.0).func_181669_b(r, g, b, 255).func_181675_d();
                buffer.func_181662_b(0.0, s, 0.0).func_187315_a(len / s / 2.0 + moving, 1.0).func_181669_b(r, g, b, 255).func_181675_d();
                buffer.func_181662_b(len, s, 0.0).func_187315_a(moving, 1.0).func_181669_b(r * 3 / 4, g * 3 / 4, b * 3 / 4, 255).func_181675_d();
                buffer.func_181662_b(len, -s, 0.0).func_187315_a(moving, 0.0).func_181669_b(r * 3 / 4, g * 3 / 4, b * 3 / 4, 255).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean mousePressed(MouseButton button) {
        boolean b = super.mousePressed(button);
        if (!b && !this.treeGui.viewQuestPanel.hidePanel && this.treeGui.getViewedQuest() != null) {
            this.treeGui.closeQuest();
        }
        if (!b && button.isLeft() && this.isMouseOver() && (this.treeGui.viewQuestPanel.hidePanel || this.treeGui.getViewedQuest() == null)) {
            this.treeGui.prevMouseX = this.getMouseX();
            this.treeGui.prevMouseY = this.getMouseY();
            this.treeGui.grabbed = 1;
            b = true;
        }
        return b;
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        this.treeGui.grabbed = 0;
    }

    public boolean scrollPanel(int scroll) {
        if (this.treeGui.selectedChapter != null && this.treeGui.getViewedQuest() == null && this.isMouseOver()) {
            this.treeGui.addZoom(scroll);
            return true;
        }
        return false;
    }
}

