/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateTaskAt;
import com.feed_the_beast.ftbquests.net.edit.MessageMoveQuest;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class ButtonDummyQuest
extends Widget {
    public GuiQuestTree treeGui;
    public final byte x;
    public final byte y;

    public ButtonDummyQuest(Panel panel, byte _x, byte _y) {
        super(panel);
        this.treeGui = (GuiQuestTree)panel.getGui();
        this.setSize(20, 20);
        this.x = _x;
        this.y = _y;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.treeGui.viewQuestPanel.isMouseOver() || this.treeGui.chapterHoverPanel.isMouseOverAnyWidget()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public boolean mousePressed(MouseButton button) {
        if (!this.isMouseOver()) {
            return false;
        }
        if (this.treeGui.movingQuest && this.treeGui.selectedQuests.size() == 1 && this.treeGui.file.canEdit()) {
            GuiHelper.playClickSound();
            new MessageMoveQuest(this.treeGui.selectedQuests.iterator().next().id, this.x, this.y).sendToServer();
            this.treeGui.movingQuest = false;
            this.treeGui.closeQuest();
            return true;
        }
        if (button.isRight() && this.treeGui.file.canEdit()) {
            GuiHelper.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            for (QuestTaskType type : QuestTaskType.getRegistry()) {
                contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                    GuiHelper.playClickSound();
                    type.getGuiProvider().openCreationGui((IOpenableGui)this, new Quest(this.treeGui.selectedChapter), task -> new MessageCreateTaskAt(this.treeGui.selectedChapter, this.x, this.y, (QuestTask)task).sendToServer());
                }));
            }
            this.getGui().openContextMenu(contextMenu);
            return true;
        }
        return false;
    }

    public void addMouseOverText(List<String> list) {
        if (this.treeGui.movingQuest && this.treeGui.selectedQuests.size() == 1) {
            list.add(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]));
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        if (!this.treeGui.file.canEdit()) {
            return;
        }
        int z = this.treeGui.getZoom();
        int s = (int)((double)z * 3.0 / 2.0);
        double sx = (double)x + (double)(w - s) / 2.0;
        double sy = (double)y + (double)(h - s) / 2.0;
        if (this.treeGui.selectedQuests.size() == 1 && this.treeGui.movingQuest) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)sx, (double)sy, (double)0.0);
            GlStateManager.func_179139_a((double)s, (double)s, (double)1.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            this.treeGui.selectedQuests.iterator().next().shape.shape.draw(0, 0, 1, 1, Color4I.WHITE.withAlpha(20));
            GlStateManager.func_179121_F();
        }
        if (this.isMouseOver()) {
            Color4I.WHITE.withAlpha(30).draw(x + (w - s) / 2, y + (h - s) / 2, s, s);
        }
    }
}

