/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.editor;

import com.feed_the_beast.ftblib.lib.config.ConfigEnum;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.feed_the_beast.ftbquests.gui.editor.ConfigEditedCallback;
import java.util.Collection;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;

public class ConfigComboBox<T>
extends ComboBox<T>
implements EventHandler<ActionEvent> {
    public final ConfigEnum<T> config;
    public final ConfigEditedCallback callback;

    public ConfigComboBox(ConfigEnum<T> c, ConfigEditedCallback ca) {
        this.config = c;
        this.callback = ca;
        NameMap nameMap = this.config.getNameMap();
        this.getItems().addAll((Collection)nameMap.values);
        this.setOnAction(this);
        this.setCellFactory(callback -> new ListCell<T>(){

            public void updateItem(T object, boolean empty) {
                super.updateItem(object, empty);
                if (empty) {
                    this.setText(null);
                } else {
                    this.setText(ConfigComboBox.this.config.getNameMap().getDisplayName((ICommandSender)Minecraft.func_71410_x().field_71439_g, object).func_150260_c());
                }
            }
        });
        this.getSelectionModel().select(this.config.getValue());
    }

    public void handle(ActionEvent event) {
        this.config.setValue(this.getSelectionModel().getSelectedItem());
        this.callback.configEdited((ConfigValue)this.config);
    }
}

