/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.chest;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.GuiRewardNotifications;
import com.feed_the_beast.ftbquests.net.MessageClaimAllRewards;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ButtonClaimAllRewards
extends Button {
    public ButtonClaimAllRewards(Panel panel) {
        super(panel, I18n.func_135052_a((String)"ftbquests.reward.claim_all", (Object[])new Object[0]), (Icon)Icon.EMPTY);
    }

    public void onClicked(MouseButton button) {
        GuiHelper.playClickSound();
        new GuiRewardNotifications().openGui();
        new MessageClaimAllRewards().sendToServer();
    }

    public void addMouseOverText(List<String> list) {
        list.add(this.getTitle());
        if (ClientQuestFile.existsWithTeam()) {
            for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
                for (Quest quest : chapter.quests) {
                    if (!quest.isComplete(ClientQuestFile.INSTANCE.self)) continue;
                    for (QuestReward reward : quest.rewards) {
                        if (ClientQuestFile.INSTANCE.isRewardClaimed(reward)) continue;
                        String s = TextFormatting.GRAY + "- " + reward.getTitle();
                        if (reward.isTeamReward()) {
                            s = s + TextFormatting.BLUE + " [" + I18n.func_135052_a((String)"ftbquests.reward.team_reward", (Object[])new Object[0]) + "]";
                        }
                        list.add(s);
                    }
                }
            }
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
        }
    }
}

