/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.command;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftbquests.command.CommandFTBQuestsBase;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CommandExportRewardsToChest
extends CommandFTBQuestsBase {
    public String func_71517_b() {
        return "export_rewards_to_chest";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>(ServerQuestFile.INSTANCE.rewardTables.size());
            for (RewardTable table : ServerQuestFile.INSTANCE.rewardTables) {
                if (table.lootCrate == null) continue;
                list.add(table.lootCrate.stringID);
            }
            for (RewardTable table : ServerQuestFile.INSTANCE.rewardTables) {
                if (table.lootCrate != null) continue;
                list.add(table.getCodeString());
            }
            return CommandExportRewardsToChest.func_175762_a((String[])args, list);
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        IItemHandler handler;
        TileEntity tileEntity;
        EntityPlayerMP player = CommandExportRewardsToChest.func_71521_c((ICommandSender)sender);
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        RewardTable table = ServerQuestFile.INSTANCE.getRewardTable(args[0]);
        if (table == null) {
            throw FTBLib.error((ICommandSender)sender, (String)"commands.ftbquests.import_rewards_from_chest.invalid_id", (Object[])new Object[]{args[0]});
        }
        RayTraceResult ray = MathUtils.rayTrace((EntityPlayer)player, (boolean)false);
        if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK && (tileEntity = player.field_70170_p.func_175625_s(ray.func_178782_a())) != null && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, ray.field_178784_b)) != null) {
            int r = 0;
            for (WeightedReward reward : table.rewards) {
                Object object = reward.reward.getIngredient();
                if (!(object instanceof ItemStack) || ((ItemStack)object).func_190926_b()) continue;
                ItemStack stack1 = ((ItemStack)object).func_77946_l();
                stack1.func_190920_e(1);
                if (!ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack1, (boolean)false).func_190926_b()) continue;
                ++r;
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ftbquests.export_rewards_to_chest.text", new Object[]{Integer.toString(r), Integer.toString(table.rewards.size()), table.getTitle()}));
        }
    }
}

