/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftblib.events.SidebarButtonCreatedEvent;
import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.client.RenderProgressScreen;
import com.feed_the_beast.ftbquests.client.RenderTaskScreen;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.item.ItemLootCrate;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenCore;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenCore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="ftbquests", value={Side.CLIENT})
public class FTBQuestsClientEventHandler {
    private static final ResourceLocation QUESTS_BUTTON = new ResourceLocation("ftbquests", "quests");
    public static TextureAtlasSprite inputBlockSprite;

    private static void addModel(Item item, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.SCREEN, "facing=north");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.PROGRESS_DETECTOR, "normal");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.PROGRESS_SCREEN, "facing=north");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.CHEST, "facing=north");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.LOOT_CRATE_STORAGE, "normal");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.LOOT_CRATE_OPENER, "normal");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.BOOK, "inventory");
        FTBQuestsClientEventHandler.addModel(FTBQuestsItems.LOOTCRATE, "inventory");
        ClientRegistry.bindTileEntitySpecialRenderer(TileTaskScreenCore.class, (TileEntitySpecialRenderer)new RenderTaskScreen());
        ClientRegistry.bindTileEntitySpecialRenderer(TileProgressScreenCore.class, (TileEntitySpecialRenderer)new RenderProgressScreen());
    }

    @SubscribeEvent
    public static void registerItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186730_a((stack, tintIndex) -> {
            LootCrate crate = ItemLootCrate.getCrate(null, stack);
            return crate == null ? -1 : 0xFF000000 | crate.color.rgb();
        }, new Item[]{FTBQuestsItems.LOOTCRATE});
    }

    @SubscribeEvent
    public static void onSidebarButtonCreated(SidebarButtonCreatedEvent event) {
        if (event.getButton().id.equals((Object)QUESTS_BUTTON)) {
            event.getButton().setCustomTextHandler(() -> {
                if (ClientQuestFile.exists()) {
                    if (!ClientQuestFile.existsWithTeam()) {
                        return "[!]";
                    }
                    int r = ClientQuestFile.INSTANCE.getUnclaimedRewards(Minecraft.func_71410_x().field_71439_g.func_110124_au(), ClientQuestFile.INSTANCE.self, true);
                    if (r > 0) {
                        return Integer.toString(r);
                    }
                }
                return "";
            });
            event.getButton().setTooltipHandler(list -> {
                if (ClientQuestFile.exists() && !ClientQuestFile.existsWithTeam()) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"sidebar_button.ftbquests.quests.no_team", (Object[])new Object[0]));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (FTBQuestsClient.KEY_QUESTS.func_151468_f()) {
            ClientQuestFile.INSTANCE.openQuestGui((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    @SubscribeEvent
    public static void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("ftbquests")) {
            switch (event.getID().func_110623_a()) {
                case "open_gui": {
                    ClientQuestFile.INSTANCE.openQuestGui((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        inputBlockSprite = event.getMap().func_174942_a(new ResourceLocation("ftbquests", "blocks/screen_front_input"));
    }
}

