/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.util.text.ITextComponent;

public class ClientQuestProgress
implements ITeamData {
    private final short teamUID;
    private final String teamID;
    private final ITextComponent displayName;
    public final Int2ObjectOpenHashMap<QuestTaskData> taskData;
    public final Int2LongOpenHashMap variables;

    public ClientQuestProgress(short uid, String id, ITextComponent n) {
        this.teamUID = uid;
        this.teamID = id;
        this.displayName = n;
        this.taskData = new Int2ObjectOpenHashMap();
        this.variables = new Int2LongOpenHashMap();
        this.variables.defaultReturnValue(0L);
    }

    @Override
    public short getTeamUID() {
        return this.teamUID;
    }

    @Override
    public String getTeamID() {
        return this.teamID;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public QuestFile getFile() {
        return ClientQuestFile.INSTANCE;
    }

    @Override
    public QuestTaskData getQuestTaskData(QuestTask task) {
        QuestTaskData data = (QuestTaskData)this.taskData.get(task.id);
        if (data == null) {
            return task.createData(this);
        }
        return data;
    }

    @Override
    public void syncTask(QuestTaskData data) {
        this.getFile().clearCachedProgress(this.getTeamUID());
    }

    @Override
    public void removeTask(QuestTask task) {
        this.taskData.remove(task.id);
    }

    @Override
    public void createTaskData(QuestTask task) {
        this.taskData.put(task.id, (Object)task.createData(this));
    }

    @Override
    public void unclaimRewards(Collection<QuestReward> rewards) {
        if (ClientQuestFile.INSTANCE.self != null && this.teamUID == ClientQuestFile.INSTANCE.self.teamUID) {
            for (QuestReward reward : rewards) {
                ClientQuestFile.INSTANCE.rewards.rem(reward.id);
            }
        }
    }

    @Override
    public long getVariable(int variable) {
        return this.variables.get(variable);
    }

    @Override
    public void setVariable(int variable, long value) {
        if (value <= 0L) {
            this.variables.remove(variable);
        } else {
            this.variables.put(variable, value);
        }
    }

    @Override
    public boolean isRewardClaimed(UUID player, QuestReward reward) {
        return ClientQuestFile.INSTANCE.self != null && this.teamUID == ClientQuestFile.INSTANCE.self.teamUID && ClientQuestFile.INSTANCE.rewards.contains(reward.id);
    }

    @Override
    public void checkAutoCompletion(Quest quest) {
    }
}

