/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import rustic.common.crafting.AdvancedCondenserRecipe;
import rustic.common.crafting.BasicCondenserRecipe;
import rustic.common.crafting.CondenserRecipe;
import rustic.common.crafting.Recipes;
import rustic.common.util.ElixirUtils;
import rustic.compat.crafttweaker.CraftTweakerHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rustic.Condenser")
public class Condenser {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input1, IItemStack input2) {
        BasicCondenserRecipe r = new BasicCondenserRecipe(CraftTweakerHelper.toStack(output), CraftTweakerHelper.toStack(input1), CraftTweakerHelper.toStack(input2));
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack modifier, IItemStack[] inputs) {
        AdvancedCondenserRecipe r = new AdvancedCondenserRecipe(CraftTweakerHelper.toStack(output), CraftTweakerHelper.toStack(modifier), CraftTweakerHelper.toStacks(inputs));
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (!CraftTweakerHelper.toStack(output).func_190926_b()) {
            CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            List<PotionEffect> effects = ElixirUtils.getEffects(this.output);
            Iterator<CondenserRecipe> it = Recipes.condenserRecipes.iterator();
            while (it.hasNext()) {
                CondenserRecipe r = it.next();
                List<PotionEffect> rEffects = ElixirUtils.getEffects(r.getResult());
                if (r == null || r.getResult() == null || !r.getResult().func_77969_a(this.output)) continue;
                for (PotionEffect pe : effects) {
                    boolean hasMatch = false;
                    for (PotionEffect pe1 : rEffects) {
                        if (pe.func_188419_a() != pe1.func_188419_a() || pe.func_76458_c() != pe1.func_76458_c() || pe.func_76459_b() != pe1.func_76459_b()) continue;
                        hasMatch = true;
                        break;
                    }
                    if (hasMatch) continue;
                    break;
                }
                if (!effects.equals(rEffects)) continue;
                it.remove();
            }
        }

        public String describe() {
            return "Removing Condenser Recipes for Item " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final CondenserRecipe recipe;

        public Add(CondenserRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            Recipes.condenserRecipes.add(this.recipe);
        }

        public String describe() {
            return "Adding Alchemy Recipe for Item " + this.recipe.getResult().func_82833_r();
        }
    }
}

