/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.shapes;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.module.IModuleShape;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceShape;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RenderUtils;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.common.module.shapes.IShapeOverrides;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="shape_self")
public class ModuleShapeSelf
implements IModuleShape {
    @Override
    public boolean run(@NotNull World world, ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity caster = spell.getCaster(world);
        if (caster == null) {
            return false;
        }
        if (!spellRing.taxCaster(world, spell, true)) {
            return false;
        }
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        overrides.onRunSelf(world, spell, spellRing);
        spell.processEntity(caster, false);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceShape instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        IShapeOverrides overrides = spellRing.getOverrideHandler().getConsumerInterface(IShapeOverrides.class);
        if (overrides.onRenderSelf(world, spell, spellRing)) {
            return;
        }
        Entity caster = spell.getCaster(world);
        if (caster == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, 0.3f));
        glitter.enableMotionCalculation();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)caster.func_174791_d()), (int)50, (int)5, (i, build) -> {
            double radius = 1.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            build.setPositionOffset(new Vec3d(RandUtil.nextDouble(-0.5, 0.5), RandUtil.nextDouble(-0.5, 0.5), RandUtil.nextDouble(-0.5, 0.5)));
            build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.2f, 1.0f), 0.0f));
            build.setMotion(new Vec3d(x, RandUtil.nextDouble(radius / 2.0, radius), z).func_72432_b().func_186678_a((double)RandUtil.nextFloat()));
            build.setAcceleration(Vec3d.field_186680_a);
            build.setLifetime(50);
            build.setDeceleration(new Vec3d(0.8, 0.8, 0.8));
            if (RandUtil.nextBoolean()) {
                build.setColorFunction((InterpFunction)new InterpColorHSV(spellRing.getPrimaryColor(), spellRing.getSecondaryColor()));
            } else {
                build.setColorFunction((InterpFunction)new InterpColorHSV(spellRing.getSecondaryColor(), spellRing.getPrimaryColor()));
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SpellData renderVisualization(@Nonnull World world, ModuleInstanceShape instance, @Nonnull SpellData data, @Nonnull SpellRing ring, float partialTicks) {
        Vec3d target = data.getTarget(world);
        Entity caster = data.getCaster(world);
        if (caster == null) {
            return data;
        }
        if (target == null) {
            target = caster.func_174791_d();
            data.addData(SpellData.DefaultKeys.TARGET_HIT, target);
            data.addData(SpellData.DefaultKeys.TARGET_HIT, target);
        }
        double interpPosX = caster.field_70142_S + (caster.field_70165_t - caster.field_70142_S) * (double)partialTicks;
        double interpPosY = caster.field_70137_T + (caster.field_70163_u - caster.field_70137_T) * (double)partialTicks;
        double interpPosZ = caster.field_70136_U + (caster.field_70161_v - caster.field_70136_U) * (double)partialTicks;
        RenderUtils.drawCircle(new Vec3d(interpPosX, interpPosY + (double)caster.field_70131_O / 2.0, interpPosZ), 0.55, false, true);
        RenderUtils.drawCircle(new Vec3d(interpPosX, interpPosY + (double)caster.field_70131_O / 2.0, interpPosZ), 0.6, false, true);
        return data;
    }

    @ModuleOverride(value="shape_self_run")
    public void onRunSelf(World world, SpellData data, SpellRing shape) {
    }

    @ModuleOverride(value="shape_self_render")
    public boolean onRenderSelf(World world, SpellData data, SpellRing shape) {
        return false;
    }
}

