/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.ILingeringModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ContextRing;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.init.ModPotions;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_time_slow")
public class ModuleEffectTimeSlow
implements IModuleEffect,
ILingeringModule {
    @SubscribeEvent
    public static void skipTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().getEntityData().func_74764_b("skip_tick") && event.getEntity().getEntityData().func_74764_b("skip_tick_interval") && event.getEntity().getEntityData().func_74764_b("skip_tick_interval_save")) {
            int tickCountdown = event.getEntity().getEntityData().func_74762_e("skip_tick");
            int tickInterval = event.getEntity().getEntityData().func_74762_e("skip_tick_interval");
            if (tickInterval <= 0) {
                event.getEntity().getEntityData().func_74768_a("skip_tick_interval", event.getEntity().getEntityData().func_74762_e("skip_tick_interval_save"));
                if (tickCountdown <= 0) {
                    event.getEntity().getEntityData().func_82580_o("skip_tick");
                    event.getEntity().getEntityData().func_82580_o("skip_tick_interval");
                    event.getEntity().getEntityData().func_82580_o("skip_tick_interval_save");
                } else {
                    event.getEntity().getEntityData().func_74768_a("skip_tick", --tickCountdown);
                    event.setCanceled(true);
                }
            } else {
                event.getEntity().getEntityData().func_74768_a("skip_tick_interval", --tickInterval);
            }
        }
    }

    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_potency", "modifier_extend_time"};
    }

    @ModuleOverride(value="shape_zone_run")
    public boolean onRunZone(World world, SpellData data, SpellRing ring, @ContextRing SpellRing childRing) {
        double aoe = ring.getAttributeValue(world, AttributeRegistry.AREA, data);
        double range = ring.getAttributeValue(world, AttributeRegistry.RANGE, data);
        Vec3d targetPos = data.getTarget(world);
        if (targetPos == null) {
            return false;
        }
        Vec3d min = targetPos.func_178786_a(aoe, range, aoe);
        Vec3d max = targetPos.func_72441_c(aoe, range, aoe);
        List entities = world.func_72839_b(null, new AxisAlignedBB(min, max));
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLivingBase) || ((EntityLivingBase)entity).func_70644_a((Potion)ModPotions.TIME_SLOW) || !(entity.func_70092_e(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c) <= aoe * aoe)) continue;
            data.processEntity(entity, false);
            this.runOnStart(world, data, childRing);
        }
        return true;
    }

    @Override
    public boolean runOnStart(@Nonnull World world, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        BlockPos targetPos = spell.getTargetPos();
        Entity targetEntity = spell.getVictim(world);
        Entity caster = spell.getCaster(world);
        if (targetEntity instanceof EntityLivingBase && !((EntityLivingBase)targetEntity).func_70644_a((Potion)ModPotions.TIME_SLOW)) {
            double potency = spellRing.getAttributeValue(world, AttributeRegistry.POTENCY, spell);
            double duration = spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 10.0f;
            if (!spellRing.taxCaster(world, spell, true)) {
                return false;
            }
            ((EntityLivingBase)targetEntity).func_70690_d(new PotionEffect((Potion)ModPotions.TIME_SLOW, (int)duration, (int)potency, false, false));
            ((EntityLivingBase)targetEntity).func_70690_d(new PotionEffect(MobEffects.field_76419_f, (int)duration, (int)potency, false, false));
        }
        return true;
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity victim = spell.getVictim(world);
        if (victim == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
        glitter.setCollision(true);
        glitter.enableMotionCalculation();
        glitter.setAcceleration(new Vec3d(0.0, RandUtil.nextBoolean() ? -1.0E-4 : 1.0E-4, 0.0));
        glitter.disableRandom();
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)victim.func_174791_d().func_72441_c(0.0, (double)(victim.field_70131_O / 2.0f), 0.0)), (int)5, (int)0, (aFloat, particleBuilder) -> {
            glitter.setLifetime(RandUtil.nextInt(40, 80));
            glitter.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.5f, 1.0f), 0.0f));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 0.5f));
            double radius = RandUtil.nextDouble(0.0, 2.0);
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            Vec3d dest = new Vec3d(x, RandUtil.nextDouble(-radius, radius), z);
            glitter.setPositionOffset(dest);
            glitter.setMotion(new Vec3d(RandUtil.nextDouble(-0.001, 0.001), 0.0, RandUtil.nextDouble(-0.001, 0.001)));
        });
    }

    @Override
    public int getLingeringTime(World world, SpellData spell, SpellRing spellRing) {
        double duration = spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 10.0f;
        return (int)duration;
    }
}

