/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core;

import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class LightningTracker {
    public static LightningTracker INSTANCE = new LightningTracker();
    private HashMap<Entity, TrackingEntry> entityToEntry = new HashMap();
    private LinkedList<TrackingEntry> newEntries = new LinkedList();

    private LightningTracker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void addEntity(Vec3d origin, Entity target, Entity caster, double potency, double duration) {
        double dist = target.func_174791_d().func_178788_d(origin).func_72433_c();
        int numPoints = (int)(dist * 3.0);
        this.newEntries.add(new TrackingEntry(numPoints, potency, duration, caster, target));
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        this.newEntries.forEach(e -> this.entityToEntry.put(e.getTarget(), (TrackingEntry)e));
        this.newEntries.clear();
        this.entityToEntry.keySet().removeIf(entity -> {
            TrackingEntry entry = this.entityToEntry.get(entity);
            Entity caster = entry.getCaster();
            int ticks = entry.getTicks();
            double potency = entry.getPotency();
            double duration = entry.getDuration();
            if (ticks > 0) {
                entry.setTicks(ticks - 1);
                return false;
            }
            entity.func_70015_d((int)duration);
            int invTime = entity.field_70172_ad;
            entity.field_70172_ad = 0;
            if (caster instanceof EntityPlayer) {
                entity.func_70097_a((DamageSource)new EntityDamageSource("lightningbolt", caster), (float)potency);
            } else {
                entity.func_70097_a(DamageSource.field_180137_b, (float)potency);
            }
            entity.field_70172_ad = invTime;
            return true;
        });
    }

    private static class TrackingEntry {
        private int ticks;
        private final double potency;
        private final double duration;
        private final Entity caster;
        private final Entity target;

        TrackingEntry(int ticks, double potency, double duration, Entity caster, Entity target) {
            this.ticks = ticks;
            this.potency = potency;
            this.duration = duration;
            this.caster = caster;
            this.target = target;
        }

        public final void setTicks(int ticks) {
            this.ticks = ticks;
        }

        public final int getTicks() {
            return this.ticks;
        }

        public final double getPotency() {
            return this.potency;
        }

        public final double getDuration() {
            return this.duration;
        }

        public final Entity getCaster() {
            return this.caster;
        }

        public final Entity getTarget() {
            return this.target;
        }
    }
}

