/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api;

import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpLine;
import com.teamwizardry.wizardry.api.util.RandUtilSeed;
import com.teamwizardry.wizardry.api.util.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.util.math.Vec3d;

public class LightningGenerator {
    public static final int POINTS_PER_DIST = 3;
    public static final float ANGLE_OFFSET = 22.5f;
    public static final float ANGLE_OFFSET_RADS = (float)Math.toRadians(22.5);
    public static final int MAX_BRANCHES = 2;

    public static TreeNode<Vec3d> generate(RandUtilSeed rand, Vec3d from, Vec3d to, double offshootRange) {
        TreeNode<Vec3d> root = new TreeNode<Vec3d>(from);
        LightningGenerator.generateOffshoot(rand, root, to, offshootRange, 2);
        return root;
    }

    private static TreeNode<Vec3d> generateOffshoot(RandUtilSeed rand, TreeNode<Vec3d> from, Vec3d to, double offshootRange, int numBranchesLeft) {
        if (numBranchesLeft < 0) {
            return from;
        }
        TreeNode<Vec3d> bolt = from;
        InterpLine interp = new InterpLine(from.getData(), to);
        ArrayList<Float> points = new ArrayList<Float>();
        double dist = to.func_178788_d(from.getData()).func_72433_c();
        points.add(Float.valueOf(1.0f));
        int i = 0;
        while ((double)i < dist * 3.0) {
            points.add(Float.valueOf(rand.nextFloat()));
            ++i;
        }
        Collections.sort(points);
        Iterator iterator = points.iterator();
        while (iterator.hasNext()) {
            float point = ((Float)iterator.next()).floatValue();
            float pitchOff = rand.nextFloat(-ANGLE_OFFSET_RADS, ANGLE_OFFSET_RADS);
            float yawOff = rand.nextFloat(-ANGLE_OFFSET_RADS, ANGLE_OFFSET_RADS);
            Vec3d newPoint = (Vec3d)interp.get(point);
            Vec3d diff = newPoint.func_178788_d(bolt.getData());
            Vec3d norm = diff.func_72432_b();
            Vec3d dir = norm.func_178789_a(pitchOff).func_178785_b(yawOff).func_72432_b();
            newPoint = dir.func_186678_a(norm.func_72430_b(diff) / norm.func_72430_b(dir)).func_178787_e(bolt.getData());
            bolt = bolt.addChild(new TreeNode<Vec3d>(newPoint));
            while (rand.nextInt(10) == 0) {
                double scale = rand.nextDouble(offshootRange / 2.0, offshootRange);
                float pitch = rand.nextFloat(ANGLE_OFFSET_RADS / 2.0f, 3.0f * ANGLE_OFFSET_RADS / 2.0f) * (float)(rand.nextBoolean() ? 1 : -1);
                float yaw = rand.nextFloat(ANGLE_OFFSET_RADS / 2.0f, 3.0f * ANGLE_OFFSET_RADS / 2.0f) * (float)(rand.nextBoolean() ? 1 : -1);
                Vec3d newTo = bolt.getData().func_178788_d(from.getData()).func_178789_a(pitch).func_178785_b(yaw).func_72432_b().func_186678_a(scale).func_178787_e(bolt.getData());
                LightningGenerator.generateOffshoot(rand, bolt, newTo, scale, numBranchesLeft - 1);
            }
        }
        return from;
    }
}

