/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.wireless;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.machines.config.config.ChargerConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.wireless.BlockAntenna;
import crazypants.enderio.machines.machine.wireless.BlockNormalWirelessCharger;
import crazypants.enderio.util.ClientUtil;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockEnhancedWirelessCharger
extends BlockNormalWirelessCharger
implements IResourceTooltipProvider,
IHaveRenderers {
    @Nonnull
    public static final PropertyEnum<E> PUP = PropertyEnum.func_177709_a((String)"up", E.class);
    @Nonnull
    public static final PropertyEnum<E> PEAST = PropertyEnum.func_177709_a((String)"east", E.class);
    @Nonnull
    public static final PropertyEnum<E> PWEST = PropertyEnum.func_177709_a((String)"west", E.class);
    @Nonnull
    public static final PropertyEnum<E> PNORTH = PropertyEnum.func_177709_a((String)"north", E.class);
    @Nonnull
    public static final PropertyEnum<E> PSOUTH = PropertyEnum.func_177709_a((String)"south", E.class);

    public static BlockEnhancedWirelessCharger create(@Nonnull IModObject modObject) {
        BlockEnhancedWirelessCharger res = new BlockEnhancedWirelessCharger(modObject);
        res.init();
        return res;
    }

    private BlockEnhancedWirelessCharger(@Nonnull IModObject modObject) {
        super(modObject);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(PUP, (Comparable)((Object)E.DISH)).func_177226_a(PEAST, (Comparable)((Object)E.DISH)).func_177226_a(PWEST, (Comparable)((Object)E.DISH)).func_177226_a(PNORTH, (Comparable)((Object)E.DISH)).func_177226_a(PSOUTH, (Comparable)((Object)E.DISH)));
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PUP, PEAST, PWEST, PNORTH, PSOUTH});
    }

    private boolean canConnect(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing dir) {
        IBlockState other = world.func_180495_p(pos.func_177972_a(dir));
        return other.func_177230_c() == MachineObject.block_wireless_charger_extension.getBlockNN() && other.func_177229_b(BlockAntenna.BASE) == dir.func_176734_d();
    }

    @Override
    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return state.func_177226_a(PUP, (Comparable)((Object)(this.canConnect(world, pos, EnumFacing.UP) ? E.CONNECTOR : E.DISH))).func_177226_a(PEAST, (Comparable)((Object)(this.canConnect(world, pos, EnumFacing.EAST) ? E.CONNECTOR : E.DISH))).func_177226_a(PWEST, (Comparable)((Object)(this.canConnect(world, pos, EnumFacing.WEST) ? E.CONNECTOR : E.DISH))).func_177226_a(PNORTH, (Comparable)((Object)(this.canConnect(world, pos, EnumFacing.NORTH) ? E.CONNECTOR : E.DISH))).func_177226_a(PSOUTH, (Comparable)((Object)(this.canConnect(world, pos, EnumFacing.SOUTH) ? E.CONNECTOR : E.DISH)));
    }

    @Override
    public void registerRenderers(@Nonnull IModObject modObject) {
        ClientUtil.registerDefaultItemRenderer((IModObject)MachineObject.block_enhanced_wireless_charger);
    }

    @Override
    @Nonnull
    protected BoundingBox getChargingStrength(@Nonnull IBlockState state, @Nonnull BlockPos pos) {
        int r = (Integer)ChargerConfig.wirelessRangeEnhancedAntenna.get();
        int x0 = pos.func_177958_n() - r;
        int y0 = pos.func_177956_o() - r;
        int z0 = pos.func_177952_p() - r;
        int x1 = pos.func_177958_n() + 1 + r;
        int y1 = pos.func_177956_o() + 1 + r;
        int z1 = pos.func_177952_p() + 1 + r;
        if (state.func_177229_b(PUP) == E.CONNECTOR) {
            y1 += ((Integer)ChargerConfig.wirelessRangeEnhancedAntennaExtension.get()).intValue();
        }
        if (state.func_177229_b(PEAST) == E.CONNECTOR) {
            x1 += ((Integer)ChargerConfig.wirelessRangeEnhancedAntennaExtension.get()).intValue();
        }
        if (state.func_177229_b(PWEST) == E.CONNECTOR) {
            x0 -= ((Integer)ChargerConfig.wirelessRangeEnhancedAntennaExtension.get()).intValue();
        }
        if (state.func_177229_b(PNORTH) == E.CONNECTOR) {
            z0 -= ((Integer)ChargerConfig.wirelessRangeEnhancedAntennaExtension.get()).intValue();
        }
        if (state.func_177229_b(PSOUTH) == E.CONNECTOR) {
            z1 += ((Integer)ChargerConfig.wirelessRangeEnhancedAntennaExtension.get()).intValue();
        }
        return new BoundingBox((float)x0, (float)y0, (float)z0, (float)x1, (float)y1, (float)z1);
    }

    static enum E implements IStringSerializable
    {
        DISH,
        CONNECTOR;


        @Nonnull
        public String func_176610_l() {
            return (String)NullHelper.notnullJ((Object)this.name().toLowerCase(Locale.ENGLISH), (String)"String.toLowerCase()");
        }
    }
}

