/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.vat;

import com.enderio.core.client.ClientUtil;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.machine.base.block.BlockMachineExtension;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskBlock;
import crazypants.enderio.base.machine.render.RenderMappers;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.vat.ContainerVat;
import crazypants.enderio.machines.machine.vat.GuiVat;
import crazypants.enderio.machines.machine.vat.TileVat;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockVat<T extends TileVat>
extends AbstractPoweredTaskBlock<T>
implements IPaintable.INonSolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockVat<TileVat> create(@Nonnull IModObject modObject) {
        BlockVat<TileVat> res = new BlockVat<TileVat>(modObject);
        res.init();
        return res;
    }

    public static BlockVat<TileVat.Enhanced> create_enhanced(@Nonnull IModObject modObject) {
        BlockVat<TileVat.Enhanced> res = new BlockVat<TileVat.Enhanced>(modObject);
        res.isEnhanced = true;
        res.init();
        return res;
    }

    public static BlockMachineExtension create_extension(@Nonnull IModObject modObject) {
        return new BlockMachineExtension(modObject, (IModObject)MachineObject.block_enhanced_vat, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0));
    }

    public BlockVat(@Nonnull IModObject modObject) {
        super(modObject);
        this.setShape(this.mkShape(BlockFaceShape.SOLID, BlockFaceShape.UNDEFINED));
    }

    public int func_149717_k(@Nonnull IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileVat te) {
        return new ContainerVat(player.field_71071_by, te);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileVat te) {
        return new GuiVat(player.field_71071_by, te);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        TileVat te = (TileVat)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null && te.isActive()) {
            float pX = (float)pos.func_177958_n() + 0.5f;
            float pY = (float)pos.func_177956_o() + 0.7f;
            float pZ = (float)pos.func_177952_p() + 0.5f;
            EnumFacing dir = te.getFacing();
            pX += 0.6f * (float)dir.func_82601_c();
            pZ += 0.6f * (float)dir.func_82599_e();
            double velX = (rand.nextDouble() * 0.075 + 0.025) * (double)dir.func_82601_c();
            double velZ = (rand.nextDouble() * 0.075 + 0.025) * (double)dir.func_82599_e();
            int num = rand.nextInt(4) + 2;
            for (int k = 0; k < num; ++k) {
                ParticleManager er = Minecraft.func_71410_x().field_71452_i;
                Particle fx = er.func_178927_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), (double)pX, (double)pY, (double)pZ, 1.0, 1.0, 1.0, new int[]{0});
                if (fx == null) continue;
                fx.func_70538_b(1.0f - rand.nextFloat() * 0.2f, 1.0f - rand.nextFloat() * 0.1f, 1.0f - rand.nextFloat() * 0.2f);
                ClientUtil.setParticleVelocity((Particle)fx, (double)velX, (double)-0.06, (double)velZ);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileVat tileEntity) {
        blockStateWrapper.addCacheKey((Object)tileEntity.getFacing()).addCacheKey((Object)tileEntity.isActive());
    }

    @Nullable
    public Block getEnhancedExtensionBlock() {
        return MachineObject.block_enhanced_vat_top.getBlockNN();
    }
}

