/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.base.teleport.packet.PacketPassword;
import crazypants.enderio.machines.machine.teleport.ITravelAccessableRemoteExec;
import crazypants.enderio.machines.network.PacketHandler;
import java.awt.Point;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerTravelAccessable
extends ContainerEnder<IInventory>
implements ITravelAccessableRemoteExec.Container {
    @Nonnull
    final ITravelAccessable ta;
    final TileEntity te;
    @Nonnull
    final World world;
    @Nonnull
    final EntityPlayer player;
    final int offset;
    private int guiID = -1;

    public ContainerTravelAccessable(@Nonnull InventoryPlayer playerInv, @Nonnull ITravelAccessable travelAccessable, @Nonnull World world, int guiOffset) {
        super(playerInv, (IInventory)playerInv);
        this.ta = travelAccessable;
        this.world = world;
        this.player = playerInv.field_70458_d;
        this.offset = guiOffset;
        this.te = this.ta instanceof TileEntity ? (TileEntity)this.ta : null;
    }

    protected void addSlots(@Nonnull InventoryPlayer playerInv) {
    }

    public void addGhostSlots(List<GhostSlot> ghostSlots) {
        int x = 44 + this.offset;
        int y = 73 + this.offset;
        for (int i = 0; i < 5; ++i) {
            ghostSlots.add(new CtaGhostSlot(this.ta, i, x, y, true));
            x += 18;
        }
        x = 125 + this.offset;
        y = 10 + this.offset;
        ghostSlots.add(new CtaGhostSlot(this.ta, 0, x, y, false));
    }

    @Nonnull
    public Point getPlayerInventoryOffset() {
        return new Point(8, 103);
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer entityPlayer, int slotIndex) {
        return ItemStack.field_190927_a;
    }

    public void setGuiID(int id) {
        this.guiID = id;
    }

    public int getGuiID() {
        return this.guiID;
    }

    @Override
    public IMessage doSetAccessMode(@Nonnull ITravelAccessable.AccessMode accesmode) {
        this.ta.setAccessMode(accesmode);
        if (this.te != null) {
            IBlockState bs = this.te.func_145831_w().func_180495_p(this.te.func_174877_v());
            this.te.func_145831_w().func_184138_a(this.te.func_174877_v(), bs, bs, 3);
            this.te.func_145831_w().func_175646_b(this.te.func_174877_v(), this.te);
        }
        return null;
    }

    @Override
    public IMessage doSetLabel(@Nullable String label) {
        this.ta.setLabel(label);
        if (this.te != null) {
            IBlockState bs = this.te.func_145831_w().func_180495_p(this.te.func_174877_v());
            this.te.func_145831_w().func_184138_a(this.te.func_174877_v(), bs, bs, 3);
            this.te.func_145831_w().func_175646_b(this.te.func_174877_v(), this.te);
        }
        return null;
    }

    @Override
    public IMessage doSetVisible(boolean visible) {
        this.ta.setVisible(visible);
        if (this.te != null) {
            IBlockState bs = this.te.func_145831_w().func_180495_p(this.te.func_174877_v());
            this.te.func_145831_w().func_184138_a(this.te.func_174877_v(), bs, bs, 3);
            this.te.func_145831_w().func_175646_b(this.te.func_174877_v(), this.te);
        }
        return null;
    }

    @Override
    public IMessage doCloseGui() {
        this.player.func_71053_j();
        return null;
    }

    static class CtaGhostSlot
    extends GhostSlot {
        @Nonnull
        private ITravelAccessable ta;
        boolean isAuth;

        public CtaGhostSlot(@Nonnull ITravelAccessable ta, int slotIndex, int x, int y, boolean isAuth) {
            this.setSlot(slotIndex);
            this.setX(x);
            this.setY(y);
            this.setDisplayStdOverlay(false);
            this.setGrayOut(true);
            this.setStackSizeLimit(1);
            this.ta = ta;
            this.isAuth = isAuth;
        }

        @Nonnull
        public ItemStack getStack() {
            if (this.isAuth) {
                return (ItemStack)this.ta.getPassword().get(this.getSlot());
            }
            return this.ta.getItemLabel();
        }

        public void putStack(@Nonnull ItemStack stack, int realsize) {
            if (this.isAuth) {
                if (this.ta.getAccessMode() == ITravelAccessable.AccessMode.PROTECTED && this.ta instanceof TileEntityBase) {
                    PacketHandler.INSTANCE.sendToServer(PacketPassword.setPassword((TileEntityBase)((TileEntityBase)this.ta), (int)this.getSlot(), (ItemStack)stack));
                }
            } else if (this.ta instanceof TileEntityBase) {
                PacketHandler.INSTANCE.sendToServer((IMessage)PacketPassword.setLabel((TileEntityBase)((TileEntityBase)this.ta), (ItemStack)stack));
            }
        }
    }
}

