/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.enchanter;

import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.enchanter.EnchanterRecipe;
import crazypants.enderio.machines.machine.enchanter.TileEnchanter;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerEnchanter
extends ContainerEnder<TileEnchanter> {
    public static int FIRST_RECIPE_SLOT = 0;
    public static int NUM_RECIPE_SLOT = 3;
    public static int FIRST_INVENTORY_SLOT = 4;
    public static int NUM_INVENTORY_SLOT = 36;

    public ContainerEnchanter(EntityPlayer player, @Nonnull InventoryPlayer playerInv, @Nonnull TileEnchanter te) {
        super(playerInv, (IInventory)te);
    }

    protected void addSlots(@Nonnull InventoryPlayer playerInv) {
        final TileEnchanter te = (TileEnchanter)this.getInv();
        this.func_75146_a(new Slot((IInventory)te, 0, 16, 35){

            public int func_75219_a() {
                return 1;
            }

            public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                return te.func_94041_b(0, itemStack);
            }

            public void func_75218_e() {
                ContainerEnchanter.this.updateOutput();
            }
        });
        this.func_75146_a(new Slot((IInventory)te, 1, 65, 35){

            public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                return te.func_94041_b(1, itemStack);
            }

            public void func_75218_e() {
                ContainerEnchanter.this.updateOutput();
            }
        });
        this.func_75146_a(new Slot((IInventory)te, 2, 85, 35){

            public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                return te.func_94041_b(2, itemStack);
            }

            public void func_75218_e() {
                ContainerEnchanter.this.updateOutput();
            }
        });
        this.func_75146_a(new Slot((IInventory)te, 3, 144, 35){

            public int func_75219_a() {
                return 1;
            }

            public boolean func_75214_a(@Nullable ItemStack itemStack) {
                return false;
            }

            @Nonnull
            public ItemStack func_190901_a(@Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
                EnchanterRecipe currentEnchantmentRecipe = ((TileEnchanter)ContainerEnchanter.this.getInv()).getCurrentEnchantmentRecipe();
                if (currentEnchantmentRecipe != null) {
                    int xpCost = currentEnchantmentRecipe.getXPCost(((TileEnchanter)ContainerEnchanter.this.getInv()).getInvAsMachineRecipeInput());
                    NNList quantitiesConsumed = currentEnchantmentRecipe.getQuantitiesConsumed(((TileEnchanter)ContainerEnchanter.this.getInv()).getInvAsMachineRecipeInput());
                    for (MachineRecipeInput machineRecipeInput : quantitiesConsumed) {
                        te.func_70298_a(machineRecipeInput.slotNumber, machineRecipeInput.item.func_190916_E());
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_82242_a(-xpCost);
                    }
                } else {
                    Log.error((Object[])new Object[]{"Enchanting yielded result without resources"});
                }
                if (!te.func_145831_w().field_72995_K) {
                    te.func_145831_w().func_175718_b(1030, te.func_174877_v(), 0);
                    te.func_145831_w().func_175718_b(2005, te.func_174877_v().func_177984_a(), 0);
                }
                return stack;
            }

            public boolean func_82869_a(@Nonnull EntityPlayer player) {
                return ContainerEnchanter.this.playerHasEnoughLevels(player);
            }
        });
    }

    public void createGhostSlots(List<GhostSlot> slots) {
        slots.add((GhostSlot)new GhostBackgroundItemSlot(Items.field_151099_bA, this.getSlotFromInventory(0)));
        slots.add((GhostSlot)new GhostBackgroundItemSlot(new ItemStack(Items.field_151100_aR, 1, 4), this.getSlotFromInventory(2)));
    }

    public boolean playerHasEnoughLevels(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        return player.field_71068_ca >= ((TileEnchanter)this.getInv()).getCurrentEnchantmentCost();
    }

    private void updateOutput() {
        EnchanterRecipe currentEnchantmentRecipe = ((TileEnchanter)this.getInv()).getCurrentEnchantmentRecipe();
        if (currentEnchantmentRecipe != null) {
            IMachineRecipe.ResultStack[] completedResult = currentEnchantmentRecipe.getCompletedResult(0L, 1.0f, ((TileEnchanter)this.getInv()).getInvAsMachineRecipeInput());
            ((TileEnchanter)this.getInv()).setOutput(completedResult[0].item);
        } else {
            ((TileEnchanter)this.getInv()).setOutput(Prep.getEmpty());
        }
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer par1EntityPlayer, int par2) {
        ItemStack copyStack = Prep.getEmpty();
        Slot slot = (Slot)this.field_75151_b.get(par2);
        if (slot != null && slot.func_75216_d()) {
            ItemStack origStack = slot.func_75211_c();
            copyStack = origStack.func_77946_l();
            if (par2 <= 3 ? !this.func_75135_a(origStack, 4, this.field_75151_b.size(), true) : !(((TileEnchanter)this.getInv()).func_94041_b(0, origStack) && this.func_75135_a(origStack, 0, 1, false) || ((TileEnchanter)this.getInv()).func_94041_b(1, origStack) && this.func_75135_a(origStack, 1, 2, false) || ((TileEnchanter)this.getInv()).func_94041_b(2, origStack) && this.func_75135_a(origStack, 2, 3, false))) {
                return Prep.getEmpty();
            }
            if (Prep.isInvalid((ItemStack)origStack)) {
                slot.func_75215_d(Prep.getEmpty());
            } else {
                slot.func_75218_e();
            }
            return slot.func_190901_a(par1EntityPlayer, origStack);
        }
        return copyStack;
    }
}

