/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.obelisk.weather.ContainerWeatherObelisk;
import crazypants.enderio.machines.machine.obelisk.weather.GuiWeatherObelisk;
import crazypants.enderio.machines.machine.obelisk.weather.TileWeatherObelisk;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class WeatherObeliskRecipeCategory
extends BlankRecipeCategory<WeatherObeliskRecipeWrapper> {
    @Nonnull
    public static final String UID = "EIOWO";
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawableAnimated flame;

    public static void register(IModRegistry registry, @Nonnull IGuiHelper guiHelper) {
        if (!((Boolean)PersonalConfig.enableWeatherObeliskJEIRecipes.get()).booleanValue()) {
            return;
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new WeatherObeliskRecipeCategory(guiHelper)});
        registry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_weather_obelisk.getBlockNN()), new String[]{UID});
        registry.addRecipeClickArea(GuiWeatherObelisk.class, 155, 42, 16, 16, new String[]{UID});
        long start = System.nanoTime();
        ArrayList<WeatherObeliskRecipeWrapper> result = new ArrayList<WeatherObeliskRecipeWrapper>();
        result.add(new WeatherObeliskRecipeWrapper(new ItemStack(Items.field_151152_bP), new FluidStack(TileWeatherObelisk.WeatherTask.CLEAR.getRequiredFluidAmountType(), TileWeatherObelisk.WeatherTask.CLEAR.getRequiredFluidAmount()), TileWeatherObelisk.WeatherTask.CLEAR.getRequiredFluidAmount() / CapacitorKey.WEATHER_POWER_FLUID_USE.getDefault() * CapacitorKey.WEATHER_POWER_USE.getDefault(), "weather_sun", guiHelper));
        result.add(new WeatherObeliskRecipeWrapper(new ItemStack(Items.field_151152_bP), new FluidStack(TileWeatherObelisk.WeatherTask.RAIN.getRequiredFluidAmountType(), TileWeatherObelisk.WeatherTask.RAIN.getRequiredFluidAmount()), TileWeatherObelisk.WeatherTask.RAIN.getRequiredFluidAmount() / CapacitorKey.WEATHER_POWER_FLUID_USE.getDefault() * CapacitorKey.WEATHER_POWER_USE.getDefault(), "weather_rain", guiHelper));
        result.add(new WeatherObeliskRecipeWrapper(new ItemStack(Items.field_151152_bP), new FluidStack(TileWeatherObelisk.WeatherTask.STORM.getRequiredFluidAmountType(), TileWeatherObelisk.WeatherTask.STORM.getRequiredFluidAmount()), TileWeatherObelisk.WeatherTask.STORM.getRequiredFluidAmount() / CapacitorKey.WEATHER_POWER_FLUID_USE.getDefault() * CapacitorKey.WEATHER_POWER_USE.getDefault(), "weather_thunder", guiHelper));
        long end = System.nanoTime();
        registry.addRecipes(result, UID);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerWeatherObelisk.class, UID, 0, 1, 1, 36);
        Log.info((Object[])new Object[]{String.format("WeatherObeliskRecipeCategory: Added %d weather changing recipes to JEI in %.3f seconds.", result.size(), (double)(end - start) / 1.0E9)});
    }

    public WeatherObeliskRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("weather_obelisk");
        this.background = guiHelper.createDrawable(backgroundLocation, 19, 6, 150, 73);
        this.flame = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(backgroundLocation, 176, 0, 14, 33), 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_weather_obelisk.getBlockNN().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.flame.draw(minecraft, 62, 21);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull WeatherObeliskRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiItemStacks.init(0, true, 60, 4);
        fluidStacks.init(1, true, 3, 5, 16, 63, 8000, true, null);
        group.init(2, true, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 27, 59, 60, 10, 0, 0);
        guiItemStacks.set(ingredients);
        fluidStacks.set(ingredients);
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class WeatherObeliskRecipeWrapper
    extends BlankRecipeWrapper {
        @Nonnull
        private final ItemStack itemInput;
        @Nonnull
        private final FluidStack fluidInput;
        @Nonnull
        private final EnergyIngredient energy;
        @Nonnull
        private final IDrawable weather;

        public WeatherObeliskRecipeWrapper(@Nonnull ItemStack itemInput, @Nonnull FluidStack fluidInput, int energy, @Nonnull String weather, @Nonnull IGuiHelper guiHelper) {
            this.itemInput = itemInput;
            this.fluidInput = fluidInput;
            this.energy = new EnergyIngredient(energy);
            ResourceLocation weatherLocation = new ResourceLocation("enderio", "textures/gui/" + weather + ".png");
            this.weather = guiHelper.createDrawable(weatherLocation, 0, 0, 64, 64, 64, 64);
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInput(ItemStack.class, (Object)this.itemInput);
            ingredients.setInput(FluidStack.class, (Object)this.fluidInput);
            ingredients.setInput(EnergyIngredient.class, (Object)this.energy);
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            GlStateManager.func_179147_l();
            this.weather.draw(minecraft, 83, 4);
        }
    }
}

