/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import codechicken.multipart.TileMultipart;
import gregtech.api.GTValues;
import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.common.ConfigHolder;
import gregtech.common.multipart.FluidPipeActiveMultiPart;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipeActive;
import java.util.Map;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class DebugPipeNetInfoProvider
implements IProbeInfoProvider {
    public String getID() {
        return "gregtech:debug_pipe_net_provider";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (mode == ProbeMode.DEBUG && ConfigHolder.debug) {
            IPipeTile<?, ?> pipeTile;
            TileEntity tileEntity = world.func_175625_s(data.getPos());
            IPipeTile<?, ?> iPipeTile = pipeTile = tileEntity == null ? null : this.getAnyPipeTile(tileEntity);
            if (pipeTile != null) {
                BlockPipe<?, ?, ?> blockPipe = pipeTile.getPipeBlock();
                Object pipeNet = ((WorldPipeNet)((Object)blockPipe.getWorldPipeNet(world))).getNetFromPos(data.getPos());
                if (pipeNet != null) {
                    probeInfo.text("Net: " + pipeNet.hashCode());
                    probeInfo.text("Node Info: ");
                    StringBuilder builder = new StringBuilder();
                    Map nodeMap = ((PipeNet)pipeNet).getAllNodes();
                    Node node = nodeMap.get(data.getPos());
                    builder.append("{").append("active: ").append(node.isActive).append(", mark: ").append(node.mark).append(", blocked: ").append(node.blockedConnections).append("}");
                    probeInfo.text(builder.toString());
                }
                probeInfo.text("tile blocked: " + pipeTile.getBlockedConnections());
                if (blockPipe instanceof BlockFluidPipe) {
                    if (pipeTile instanceof TileEntityFluidPipeActive) {
                        probeInfo.text("tile active: " + ((TileEntityFluidPipeActive)pipeTile).isActive());
                    } else if (GTValues.isModLoaded("forgemultipartcbe") && pipeTile instanceof FluidPipeActiveMultiPart) {
                        probeInfo.text("tile active: " + ((FluidPipeActiveMultiPart)pipeTile).isActivePart());
                    }
                }
            }
        }
    }

    private IPipeTile<?, ?> getAnyPipeTile(TileEntity tileEntity) {
        if (tileEntity instanceof IPipeTile) {
            return (IPipeTile)tileEntity;
        }
        if (GTValues.isModLoaded("forgemultipartcbe") && tileEntity instanceof TileMultipart) {
            return ((TileMultipart)tileEntity).jPartList().stream().filter(part -> part instanceof IPipeTile).findFirst().orElse(null);
        }
        return null;
    }
}

