/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.cable.net;

import gregtech.common.pipelike.cable.WireProperties;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import java.util.HashMap;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class RoutePath {
    public BlockPos destination;
    public HashMap<BlockPos, WireProperties> path = new HashMap();
    public int maxAmperage = Integer.MAX_VALUE;
    public int minVoltage = Integer.MAX_VALUE;
    public int totalLoss;

    public RoutePath cloneAndCompute(BlockPos destination) {
        RoutePath newPath = new RoutePath();
        newPath.path = new HashMap<BlockPos, WireProperties>(this.path);
        newPath.destination = destination;
        for (WireProperties wireProperties : this.path.values()) {
            newPath.maxAmperage = Math.min(newPath.maxAmperage, wireProperties.amperage);
            newPath.minVoltage = Math.min(newPath.minVoltage, wireProperties.voltage);
            newPath.totalLoss += wireProperties.lossPerBlock;
        }
        return newPath;
    }

    public boolean burnCablesInPath(World world, long voltage, long amperage) {
        for (BlockPos blockPos : this.path.keySet()) {
            TileEntity tileEntity;
            WireProperties wireProperties = this.path.get(blockPos);
            if (voltage <= (long)wireProperties.voltage && amperage <= (long)wireProperties.amperage || !((tileEntity = world.func_175625_s(blockPos)) instanceof TileEntityCable)) continue;
            world.func_175698_g(blockPos);
            world.func_175656_a(blockPos, Blocks.field_150480_ab.func_176223_P());
            if (world.field_72995_K) continue;
            ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, 5 + world.field_73012_v.nextInt(3), 0.0, 0.0, 0.0, 0.1, new int[0]);
        }
        return true;
    }
}

