/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.render.ICubeRenderer;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class MetaTileEntityMultiblockPart
extends MetaTileEntity
implements IMultiblockPart {
    private final int tier;
    private BlockPos controllerPos;
    private MultiblockControllerBase controllerTile;

    public MetaTileEntityMultiblockPart(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId);
        this.tier = tier;
        this.initializeInventory();
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)this.getBaseTexture().getParticleSprite(), (Object)this.getPaintingColor());
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        this.getBaseTexture().render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))));
    }

    @Override
    public int getLightValue() {
        MultiblockControllerBase controller = this.getController();
        return controller == null ? 0 : controller.getLightValue(this);
    }

    public int getTier() {
        return this.tier;
    }

    public MultiblockControllerBase getController() {
        if (this.getWorld() != null && this.getWorld().field_72995_K && this.controllerTile == null && this.controllerPos != null) {
            this.controllerTile = (MultiblockControllerBase)BlockMachine.getMetaTileEntity((IBlockAccess)this.getWorld(), this.controllerPos);
        }
        if (this.controllerTile != null && (this.controllerTile.getHolder() == null || this.controllerTile.getHolder().func_145837_r() || !this.getWorld().field_72995_K && !this.controllerTile.getMultiblockParts().contains(this))) {
            this.controllerTile = null;
        }
        return this.controllerTile;
    }

    public ICubeRenderer getBaseTexture() {
        MultiblockControllerBase controller = this.getController();
        return controller == null ? Textures.VOLTAGE_CASINGS[this.tier] : controller.getBaseTexture(this);
    }

    public boolean shouldRenderOverlay() {
        MultiblockControllerBase controller = this.getController();
        return controller == null || controller.shouldRenderOverlay(this);
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return true;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        MultiblockControllerBase controller = this.getController();
        buf.writeBoolean(controller != null);
        if (controller != null) {
            buf.func_179255_a(controller.getPos());
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        if (buf.readBoolean()) {
            this.controllerPos = buf.func_179259_c();
            this.controllerTile = null;
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            if (buf.readBoolean()) {
                this.controllerPos = buf.func_179259_c();
                this.controllerTile = null;
            } else {
                this.controllerPos = null;
                this.controllerTile = null;
            }
            this.getHolder().scheduleChunkForRenderUpdate();
        }
    }

    private void setController(MultiblockControllerBase controller1) {
        this.controllerTile = controller1;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(100, writer -> {
                writer.writeBoolean(this.controllerTile != null);
                if (this.controllerTile != null) {
                    writer.func_179255_a(this.controllerTile.getPos());
                }
            });
        }
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        MultiblockControllerBase controller = this.getController();
        if (!this.getWorld().field_72995_K && controller != null) {
            controller.invalidateStructure();
        }
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        this.setController(controllerBase);
    }

    @Override
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        this.setController(null);
    }

    @Override
    public boolean isAttachedToMultiBlock() {
        return this.getController() != null;
    }
}

