/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GregFakePlayer;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityTeslaCoil
extends MetaTileEntity {
    private static final long ENERGY_PER_ONE_HEALTH_POINT_HIT = 2500L;
    private IEnergyContainer energyContainer = new EnergyContainerHandler(this, 256000L, Long.MAX_VALUE, Long.MAX_VALUE, 0L, 0L);

    public MetaTileEntityTeslaCoil(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityTeslaCoil(this.metaTileEntityId);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.TESLA_COIL.render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.TESLA_COIL.getParticleSprite(), (Object)this.getPaintingColor());
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.energyContainer.getEnergyStored() > 0L && this.getWorld().func_175640_z(this.getPos()) && this.getTimer() % 20L == 0L) {
            double damageRadius = this.getDamageRadius();
            List entities = this.getWorld().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.getPos()).func_186662_g(damageRadius));
            if (entities.isEmpty()) {
                return;
            }
            long energyAmountPerEntity = this.energyContainer.getEnergyStored() / (long)entities.size();
            int damagePerEntity = (int)(energyAmountPerEntity / 2500L);
            int damagedEntitiesCount = 0;
            if (damagePerEntity < 1) {
                return;
            }
            for (EntityLivingBase entityLiving : entities) {
                DamageSource damageSource;
                boolean damaged = entityLiving.func_70097_a(damageSource = DamageSources.causeElectricDamage((EntityLivingBase)GregFakePlayer.get((WorldServer)this.getWorld())), (float)damagePerEntity);
                if (!damaged) continue;
                ++damagedEntitiesCount;
            }
            if (damagedEntitiesCount > 0) {
                this.energyContainer.removeEnergy(energyAmountPerEntity * (long)damagedEntitiesCount);
            }
        }
    }

    protected double getDamageRadius() {
        return 6.0;
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }
}

