/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.render.SimpleOverlayRenderer;
import gregtech.api.render.Textures;
import gregtech.common.covers.filter.ItemFilterContainer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class MetaTileEntityItemCollector
extends TieredMetaTileEntity {
    private static final int[] INVENTORY_SIZES = new int[]{4, 9, 16, 25, 25};
    private static final double MOTION_MULTIPLIER = 0.04;
    private static final int BASE_EU_CONSUMPTION = 6;
    private final int maxItemSuckingRange;
    private int itemSuckingRange;
    private AxisAlignedBB areaBoundingBox;
    private BlockPos areaCenterPos;
    private boolean isWorking;
    private ItemFilterContainer itemFilter;

    public MetaTileEntityItemCollector(ResourceLocation metaTileEntityId, int tier, int maxItemSuckingRange) {
        super(metaTileEntityId, tier);
        this.maxItemSuckingRange = maxItemSuckingRange;
        this.itemSuckingRange = maxItemSuckingRange;
        this.itemFilter = new ItemFilterContainer(this::markDirty);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityItemCollector(this.metaTileEntityId, this.getTier(), this.maxItemSuckingRange);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        SimpleOverlayRenderer renderer = this.isWorking ? Textures.BLOWER_ACTIVE_OVERLAY : Textures.BLOWER_OVERLAY;
        renderer.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        Textures.AIR_VENT_OVERLAY.renderSided(EnumFacing.DOWN, renderState, translation, pipeline);
        Textures.PIPE_OUT_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
    }

    protected int getEnergyConsumedPerTick() {
        return 6 * (1 << this.getTier() - 1);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isWorking);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isWorking = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.isWorking = buf.readBoolean();
            this.getHolder().scheduleChunkForRenderUpdate();
        }
    }

    @Override
    protected boolean canMachineConnectRedstone(EnumFacing side) {
        return true;
    }

    @Override
    public void update() {
        boolean isWorkingNow;
        super.update();
        if (this.getWorld().field_72995_K) {
            return;
        }
        boolean bl = isWorkingNow = this.energyContainer.getEnergyStored() >= (long)this.getEnergyConsumedPerTick() && this.isBlockRedstonePowered();
        if (isWorkingNow) {
            this.energyContainer.removeEnergy(this.getEnergyConsumedPerTick());
            BlockPos selfPos = this.getPos();
            if (this.areaCenterPos == null || this.areaBoundingBox == null || this.areaCenterPos.func_177958_n() != selfPos.func_177958_n() || this.areaCenterPos.func_177952_p() != selfPos.func_177952_p() || this.areaCenterPos.func_177956_o() != selfPos.func_177956_o() + 1) {
                this.areaCenterPos = selfPos.func_177984_a();
                this.areaBoundingBox = new AxisAlignedBB(this.areaCenterPos).func_72314_b((double)this.itemSuckingRange, 1.0, (double)this.itemSuckingRange);
            }
            this.moveItemsInEffectRange();
        }
        if (isWorkingNow != this.isWorking) {
            this.isWorking = isWorkingNow;
            this.writeCustomData(100, buffer -> buffer.writeBoolean(isWorkingNow));
        }
    }

    protected void moveItemsInEffectRange() {
        List itemsInRange = this.getWorld().func_72872_a(EntityItem.class, this.areaBoundingBox);
        for (EntityItem entityItem : itemsInRange) {
            double distanceX = (double)this.areaCenterPos.func_177958_n() + 0.5 - entityItem.field_70165_t;
            double distanceZ = (double)this.areaCenterPos.func_177952_p() + 0.5 - entityItem.field_70161_v;
            double distance = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
            if (!this.itemFilter.testItemStack(entityItem.func_92059_d())) continue;
            if (distance >= 0.7) {
                if (entityItem.func_174874_s()) continue;
                double directionX = distanceX / distance;
                double directionZ = distanceZ / distance;
                entityItem.field_70159_w = directionX * 0.04 * (double)this.getTier();
                entityItem.field_70179_y = directionZ * 0.04 * (double)this.getTier();
                entityItem.field_70133_I = true;
                entityItem.func_174867_a(1);
                continue;
            }
            ItemStack itemStack = entityItem.func_92059_d();
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.exportItems, (ItemStack)itemStack, (boolean)false);
            if (remainder.func_190926_b()) {
                entityItem.func_70106_y();
                continue;
            }
            if (itemStack.func_190916_E() <= remainder.func_190916_E()) continue;
            entityItem.func_92058_a(remainder);
        }
        if (this.getTimer() % 5L == 0L) {
            this.pushItemsIntoNearbyHandlers(this.getFrontFacing());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_collector.collect_range", (Object[])new Object[]{this.maxItemSuckingRange, this.maxItemSuckingRange}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.max_voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VN[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_controller.tooltip.redstone", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_controller.tooltip.consumption", (Object[])new Object[]{this.getEnergyConsumedPerTick()}));
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(INVENTORY_SIZES[MathHelper.func_76125_a((int)this.getTier(), (int)0, (int)(INVENTORY_SIZES.length - 1))]);
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        return this.canPlaceCoverOnSide(side) ? (T)super.getCapability(capability, side) : null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("CollectRange", this.itemSuckingRange);
        data.func_74782_a("Filter", (NBTBase)this.itemFilter.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.itemSuckingRange = data.func_74762_e("CollectRange");
        this.itemFilter.deserializeNBT(data.func_74775_l("Filter"));
    }

    protected void setItemSuckingRange(int itemSuckingRange) {
        this.itemSuckingRange = itemSuckingRange;
        this.areaBoundingBox = null;
        this.markDirty();
    }

    protected void adjustSuckingRange(int amount) {
        this.setItemSuckingRange(MathHelper.func_76125_a((int)(this.itemSuckingRange + amount), (int)1, (int)this.maxItemSuckingRange));
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        int rowSize = (int)Math.sqrt(this.exportItems.getSlots());
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 45 + rowSize * 18 + 105 + 82).label(10, 5, this.getMetaFullName());
        builder.widget(new ClickButtonWidget(10, 20, 20, 20, "-1", data -> this.adjustSuckingRange(-1)));
        builder.widget(new ClickButtonWidget(146, 20, 20, 20, "+1", data -> this.adjustSuckingRange(1)));
        builder.widget(new ImageWidget(30, 20, 116, 20, GuiTextures.DISPLAY));
        builder.widget(new SimpleTextWidget(88, 30, "gregtech.machine.item_collector.gui.collect_range", 0xFFFFFF, () -> Integer.toString(this.itemSuckingRange)));
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                builder.widget(new SlotWidget(this.exportItems, index, 89 - rowSize * 9 + x * 18, 45 + y * 18, true, false).setBackgroundTexture(GuiTextures.SLOT));
            }
        }
        this.itemFilter.initUI(45 + rowSize * 18 + 5, builder::widget);
        builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 8, 45 + rowSize * 18 + 105);
        return builder.build(this.getHolder(), entityPlayer);
    }
}

