/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ToggleEnergyConsumerBehavior
implements IItemBehaviour {
    private final int energyUsagePerTenTicks;

    public ToggleEnergyConsumerBehavior(int energyUsagePerTenTicks) {
        this.energyUsagePerTenTicks = energyUsagePerTenTicks;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            boolean isItemActive = this.isItemActive(itemStack);
            if (isItemActive) {
                this.setItemActive(itemStack, false);
            } else if (electricItem != null && this.drainActivationEnergy(electricItem, true)) {
                this.setItemActive(itemStack, true);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
    }

    private boolean drainActivationEnergy(IElectricItem electricItem, boolean simulate) {
        return electricItem.discharge(this.energyUsagePerTenTicks, electricItem.getTier(), true, false, simulate) >= (long)this.energyUsagePerTenTicks;
    }

    @Override
    public void onUpdate(ItemStack itemStack, Entity entity) {
        boolean shouldRemainActive;
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (this.isItemActive(itemStack) && electricItem != null && !(shouldRemainActive = this.drainActivationEnergy(electricItem, false))) {
            this.setItemActive(itemStack, false);
        }
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        lines.add(I18n.func_135052_a((String)"behavior.toggle_energy_consumer.tooltip", (Object[])new Object[0]));
    }

    public boolean isItemActive(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        return tagCompound != null && tagCompound.func_74767_n("Active");
    }

    public void setItemActive(ItemStack itemStack, boolean isActive) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        tagCompound.func_74757_a("Active", isActive);
    }
}

