/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.common.covers.filter.AbstractFluidFilter;
import gregtech.common.covers.filter.FilterTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class WidgetGroupFluidFilter
extends AbstractWidgetGroup {
    private final int yPosition;
    private Supplier<AbstractFluidFilter> itemFilterSupplier;
    private AbstractFluidFilter itemFilter;

    public WidgetGroupFluidFilter(int yPosition, Supplier<AbstractFluidFilter> itemFilterSupplier) {
        this.yPosition = yPosition;
        this.itemFilterSupplier = itemFilterSupplier;
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        AbstractFluidFilter newItemFilter = this.itemFilterSupplier.get();
        if (this.itemFilter != newItemFilter) {
            this.clearAllWidgets();
            this.itemFilter = newItemFilter;
            if (this.itemFilter != null) {
                this.itemFilter.initUI(this.yPosition, this::addWidget);
            }
            this.writeUpdateInfo(2, buffer -> {
                if (this.itemFilter != null) {
                    buffer.writeBoolean(true);
                    int filterId = FilterTypeRegistry.getIdForFluidFilter(this.itemFilter);
                    buffer.func_150787_b(filterId);
                } else {
                    buffer.writeBoolean(false);
                }
            });
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 2) {
            this.clearAllWidgets();
            if (buffer.readBoolean()) {
                int filterId = buffer.func_150792_a();
                this.itemFilter = FilterTypeRegistry.createFluidFilterById(filterId);
                this.itemFilter.initUI(this.yPosition, this::addWidget);
            }
        }
    }
}

