/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.unification.OreDictUnifier;
import gregtech.common.covers.filter.AbstractItemFilter;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class OreDictionaryItemFilter
extends AbstractItemFilter {
    private static final Pattern ORE_DICTIONARY_FILTER = Pattern.compile("\\*?[a-zA-Z0-9_]*\\*?");
    protected String oreDictionaryFilter = "";

    protected void setOreDictionaryFilter(String oreDictionaryFilter) {
        this.oreDictionaryFilter = oreDictionaryFilter;
        this.markDirty();
    }

    public String getOreDictionaryFilter() {
        return this.oreDictionaryFilter;
    }

    @Override
    public int getTotalOccupiedHeight() {
        return 37;
    }

    @Override
    public void initUI(int y, Consumer<Widget> widgetGroup) {
        widgetGroup.accept(new LabelWidget(10, y, "cover.ore_dictionary_filter.title1", new Object[0]));
        widgetGroup.accept(new LabelWidget(10, y + 10, "cover.ore_dictionary_filter.title2", new Object[0]));
        widgetGroup.accept(new TextFieldWidget(10, y + 25, 100, 12, true, () -> this.oreDictionaryFilter, this::setOreDictionaryFilter).setMaxStringLength(64).setValidator(str -> ORE_DICTIONARY_FILTER.matcher((CharSequence)str).matches()));
    }

    @Override
    public boolean testItemStack(ItemStack itemStack) {
        return OreDictionaryItemFilter.matchesOreDictionaryFilter(this.getOreDictionaryFilter(), itemStack);
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("OreDictionaryFilter", this.oreDictionaryFilter);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        this.oreDictionaryFilter = tagCompound.func_74779_i("OreDictionaryFilter");
    }

    public static boolean matchesOreDictionaryFilter(String oreDictionaryFilter, ItemStack itemStack) {
        boolean endWildcard;
        if (oreDictionaryFilter.isEmpty()) {
            return false;
        }
        boolean startWildcard = oreDictionaryFilter.charAt(0) == '*';
        boolean bl = endWildcard = oreDictionaryFilter.length() > 1 && oreDictionaryFilter.charAt(oreDictionaryFilter.length() - 1) == '*';
        if (startWildcard) {
            oreDictionaryFilter = oreDictionaryFilter.substring(1);
        }
        if (endWildcard) {
            oreDictionaryFilter = oreDictionaryFilter.substring(0, oreDictionaryFilter.length() - 1);
        }
        for (String stackOreName : OreDictUnifier.getOreDictionaryNames(itemStack)) {
            if (!OreDictionaryItemFilter.areOreDictNamesEqual(startWildcard, endWildcard, oreDictionaryFilter, stackOreName)) continue;
            return true;
        }
        return false;
    }

    private static boolean areOreDictNamesEqual(boolean startWildcard, boolean endWildcard, String oreDictName, String stackOreName) {
        if (startWildcard && endWildcard) {
            return stackOreName.contains(oreDictName);
        }
        if (startWildcard) {
            return stackOreName.endsWith(oreDictName);
        }
        if (endWildcard) {
            return stackOreName.startsWith(oreDictName);
        }
        return stackOreName.equals(oreDictName);
    }
}

