/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.common.covers.filter.AbstractItemFilter;
import gregtech.common.covers.filter.ISlottedItemFilter;
import gregtech.common.covers.filter.WidgetGroupItemFilter;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;

public class ItemFilterWrapper {
    private final IDirtyNotifiable dirtyNotifiable;
    private boolean isBlacklistFilter = false;
    private int maxStackSize = 1;
    private AbstractItemFilter currentItemFilter;

    public ItemFilterWrapper(IDirtyNotifiable dirtyNotifiable) {
        this.dirtyNotifiable = dirtyNotifiable;
    }

    public void initUI(int y, Consumer<Widget> widgetGroup) {
        ServerWidgetGroup blacklistButton = new ServerWidgetGroup(() -> this.getItemFilter() != null);
        blacklistButton.addWidget(new ToggleButtonWidget(146, y, 20, 20, GuiTextures.BUTTON_BLACKLIST, this::isBlacklistFilter, this::setBlacklistFilter).setTooltipText("cover.filter.blacklist"));
        widgetGroup.accept(blacklistButton);
        widgetGroup.accept(new WidgetGroupItemFilter(y, this::getItemFilter));
    }

    public void setItemFilter(AbstractItemFilter itemFilter) {
        this.currentItemFilter = itemFilter;
        if (this.currentItemFilter != null) {
            this.currentItemFilter.setDirtyNotifiable(this.dirtyNotifiable);
        }
    }

    public AbstractItemFilter getItemFilter() {
        return this.currentItemFilter;
    }

    public void onFilterInstanceChange() {
        if (this.currentItemFilter instanceof ISlottedItemFilter) {
            ISlottedItemFilter filter = (ISlottedItemFilter)((Object)this.currentItemFilter);
            filter.setMaxStackSize(this.maxStackSize);
        }
        this.dirtyNotifiable.markAsDirty();
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        this.onFilterInstanceChange();
        this.dirtyNotifiable.markAsDirty();
    }

    public void setBlacklistFilter(boolean blacklistFilter) {
        this.isBlacklistFilter = blacklistFilter;
        this.dirtyNotifiable.markAsDirty();
    }

    public boolean isBlacklistFilter() {
        return this.isBlacklistFilter;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public int getMaxMatchSlots() {
        if (!this.isBlacklistFilter && this.currentItemFilter instanceof ISlottedItemFilter) {
            ISlottedItemFilter filter = (ISlottedItemFilter)((Object)this.currentItemFilter);
            return filter.getMaxMatchSlots();
        }
        return 1;
    }

    public int getSlotStackSize(int slotIndex) {
        if (!this.isBlacklistFilter && this.currentItemFilter instanceof ISlottedItemFilter) {
            ISlottedItemFilter filter = (ISlottedItemFilter)((Object)this.currentItemFilter);
            return filter.getSlotStackSize(slotIndex);
        }
        return -1;
    }

    public int matchItemStack(ItemStack itemStack) {
        int originalSlot = 0;
        if (this.currentItemFilter instanceof ISlottedItemFilter) {
            ISlottedItemFilter filter = (ISlottedItemFilter)((Object)this.currentItemFilter);
            originalSlot = filter.matchItemStack(itemStack);
        } else if (this.currentItemFilter != null) {
            int n = originalSlot = this.currentItemFilter.testItemStack(itemStack) ? 0 : -1;
        }
        if (this.isBlacklistFilter) {
            originalSlot = originalSlot >= 0 ? -1 : 0;
        }
        return originalSlot;
    }

    public boolean testItemStack(ItemStack itemStack) {
        return this.matchItemStack(itemStack) >= 0;
    }
}

