/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import gregtech.api.unification.stack.ItemAndMetadata;
import gregtech.api.util.GTLog;
import gregtech.common.covers.filter.AbstractFluidFilter;
import gregtech.common.covers.filter.AbstractItemFilter;
import gregtech.common.covers.filter.OreDictionaryItemFilter;
import gregtech.common.covers.filter.SimpleFluidFilter;
import gregtech.common.covers.filter.SimpleItemFilter;
import gregtech.common.items.MetaItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class FilterTypeRegistry {
    private static final Map<ItemAndMetadata, Integer> itemFilterIdByStack = new HashMap<ItemAndMetadata, Integer>();
    private static final Map<ItemAndMetadata, Integer> fluidFilterIdByStack = new HashMap<ItemAndMetadata, Integer>();
    private static final BiMap<Integer, Class<? extends AbstractItemFilter>> itemFilterById = HashBiMap.create();
    private static final BiMap<Integer, Class<? extends AbstractFluidFilter>> fluidFilterById = HashBiMap.create();

    public static void init() {
        FilterTypeRegistry.registerFluidFilter(1, SimpleFluidFilter.class, MetaItems.FLUID_FILTER.getStackForm());
        FilterTypeRegistry.registerItemFilter(2, SimpleItemFilter.class, MetaItems.ITEM_FILTER.getStackForm());
        FilterTypeRegistry.registerItemFilter(3, OreDictionaryItemFilter.class, MetaItems.ORE_DICTIONARY_FILTER.getStackForm());
    }

    public static void registerFluidFilter(int id, Class<? extends AbstractFluidFilter> fluidFilterClass, ItemStack itemStack) {
        if (fluidFilterById.containsKey((Object)id)) {
            throw new IllegalArgumentException("Id is already occupied: " + id);
        }
        fluidFilterIdByStack.put(new ItemAndMetadata(itemStack), id);
        fluidFilterById.put((Object)id, fluidFilterClass);
    }

    public static void registerItemFilter(int id, Class<? extends AbstractItemFilter> itemFilterClass, ItemStack itemStack) {
        if (itemFilterById.containsKey((Object)id)) {
            throw new IllegalArgumentException("Id is already occupied: " + id);
        }
        itemFilterIdByStack.put(new ItemAndMetadata(itemStack), id);
        itemFilterById.put((Object)id, itemFilterClass);
    }

    public static int getIdForItemFilter(AbstractItemFilter itemFilter) {
        Integer filterId = (Integer)itemFilterById.inverse().get(itemFilter.getClass());
        if (filterId == null) {
            throw new IllegalArgumentException("Unknown filter type " + itemFilter.getClass());
        }
        return filterId;
    }

    public static int getIdForFluidFilter(AbstractFluidFilter fluidFilter) {
        Integer filterId = (Integer)fluidFilterById.inverse().get(fluidFilter.getClass());
        if (filterId == null) {
            throw new IllegalArgumentException("Unknown filter type " + fluidFilter.getClass());
        }
        return filterId;
    }

    public static AbstractItemFilter createItemFilterById(int filterId) {
        Class filterClass = (Class)itemFilterById.get((Object)filterId);
        if (filterClass == null) {
            throw new IllegalArgumentException("Unknown filter id: " + filterId);
        }
        return (AbstractItemFilter)FilterTypeRegistry.createNewFilterInstance(filterClass);
    }

    public static AbstractFluidFilter createFluidFilterById(int filterId) {
        Class filterClass = (Class)fluidFilterById.get((Object)filterId);
        if (filterClass == null) {
            throw new IllegalArgumentException("Unknown filter id: " + filterId);
        }
        return (AbstractFluidFilter)FilterTypeRegistry.createNewFilterInstance(filterClass);
    }

    public static AbstractItemFilter getItemFilterForStack(ItemStack itemStack) {
        Integer filterId = itemFilterIdByStack.get(new ItemAndMetadata(itemStack));
        if (filterId == null) {
            return null;
        }
        Class filterClass = (Class)itemFilterById.get((Object)filterId);
        return (AbstractItemFilter)FilterTypeRegistry.createNewFilterInstance(filterClass);
    }

    public static AbstractFluidFilter getFluidFilterForStack(ItemStack itemStack) {
        Integer filterId = fluidFilterIdByStack.get(new ItemAndMetadata(itemStack));
        if (filterId == null) {
            return null;
        }
        Class filterClass = (Class)fluidFilterById.get((Object)filterId);
        return (AbstractFluidFilter)FilterTypeRegistry.createNewFilterInstance(filterClass);
    }

    private static <T> T createNewFilterInstance(Class<T> filterClass) {
        try {
            return filterClass.newInstance();
        }
        catch (ReflectiveOperationException exception) {
            GTLog.logger.error("Failed to create filter instance for class {}", filterClass, (Object)exception);
            return null;
        }
    }
}

