/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.generator;

import gregtech.api.worldgen.generator.CachedGridEntry;
import gregtech.common.ConfigHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldGeneratorImpl
implements IWorldGenerator {
    private static final List<OreGenEvent.GenerateMinable.EventType> ORE_EVENT_TYPES = Arrays.asList(OreGenEvent.GenerateMinable.EventType.COAL, OreGenEvent.GenerateMinable.EventType.DIAMOND, OreGenEvent.GenerateMinable.EventType.GOLD, OreGenEvent.GenerateMinable.EventType.IRON, OreGenEvent.GenerateMinable.EventType.LAPIS, OreGenEvent.GenerateMinable.EventType.REDSTONE, OreGenEvent.GenerateMinable.EventType.QUARTZ, OreGenEvent.GenerateMinable.EventType.EMERALD);
    public static final int GRID_SIZE_X = 3;
    public static final int GRID_SIZE_Z = 3;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onOreGenerate(OreGenEvent.GenerateMinable event) {
        OreGenEvent.GenerateMinable.EventType eventType = event.getType();
        if (ConfigHolder.disableVanillaOres && ORE_EVENT_TYPES.contains(eventType)) {
            event.setResult(Event.Result.DENY);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int selfGridX = Math.floorDiv(chunkX, 3);
        int selfGridZ = Math.floorDiv(chunkZ, 3);
        this.generateInternal(world, selfGridX, selfGridZ, chunkX, chunkZ, random);
    }

    private void generateInternal(World world, int selfGridX, int selfGridZ, int chunkX, int chunkZ, Random random) {
        int halfSizeX = 1;
        int halfSizeZ = 1;
        for (int gridX = -halfSizeX; gridX <= halfSizeX; ++gridX) {
            for (int gridZ = -halfSizeZ; gridZ <= halfSizeZ; ++gridZ) {
                CachedGridEntry cachedGridEntry = CachedGridEntry.getOrCreateEntry(world, selfGridX + gridX, selfGridZ + gridZ, chunkX, chunkZ);
                cachedGridEntry.populateChunk(world, chunkX, chunkZ, random);
            }
        }
    }
}

