/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.stack;

import gregtech.api.unification.stack.ItemAndMetadata;
import java.util.HashMap;
import java.util.Map;

public class WildcardAwareHashMap<V>
extends HashMap<ItemAndMetadata, V> {
    public WildcardAwareHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public WildcardAwareHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public WildcardAwareHashMap() {
    }

    public WildcardAwareHashMap(Map<? extends ItemAndMetadata, ? extends V> m) {
        super(m);
    }

    @Override
    public V get(Object key) {
        ItemAndMetadata itemStack = (ItemAndMetadata)key;
        Object resultValue = super.get(key);
        if (resultValue == null && itemStack.itemDamage != Short.MAX_VALUE) {
            ItemAndMetadata wildcardStack = new ItemAndMetadata(itemStack.item, Short.MAX_VALUE);
            resultValue = super.get(wildcardStack);
        }
        return resultValue;
    }

    @Override
    public boolean containsKey(Object key) {
        ItemAndMetadata itemStack = (ItemAndMetadata)key;
        boolean resultValue = super.containsKey(key);
        if (!resultValue && itemStack.itemDamage != Short.MAX_VALUE) {
            ItemAndMetadata wildcardStack = new ItemAndMetadata(itemStack.item, Short.MAX_VALUE);
            resultValue = super.containsKey(wildcardStack);
        }
        return resultValue;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V value = this.get(key);
        return value == null ? defaultValue : value;
    }
}

