/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import com.google.common.collect.ImmutableMap;
import gnu.trove.map.TObjectIntMap;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ValidationResult;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class IntCircuitRecipeBuilder
extends RecipeBuilder<IntCircuitRecipeBuilder> {
    protected int circuitMeta = -1;

    public IntCircuitRecipeBuilder() {
    }

    public IntCircuitRecipeBuilder(Recipe recipe, RecipeMap<IntCircuitRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public IntCircuitRecipeBuilder(RecipeBuilder<IntCircuitRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public boolean applyProperty(String key, Object value) {
        if (key.equals("circuit") && value instanceof Number) {
            this.circuitMeta = ((Number)value).intValue();
            return true;
        }
        return false;
    }

    @Override
    public IntCircuitRecipeBuilder copy() {
        return new IntCircuitRecipeBuilder(this);
    }

    public IntCircuitRecipeBuilder circuitMeta(int circuitMeta) {
        if (!GTUtility.isBetweenInclusive(0L, 32L, circuitMeta)) {
            GTLog.logger.error("Integrated Circuit Metadata cannot be less than 0 and more than 32", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.circuitMeta = circuitMeta;
        return this;
    }

    @Override
    protected EnumValidationResult finalizeAndValidate() {
        if (this.circuitMeta >= 0) {
            this.inputs.add(new CountableIngredient(new IntCircuitIngredient(this.circuitMeta), 0));
        }
        return super.finalizeAndValidate();
    }

    @Override
    public ValidationResult<Recipe> build() {
        return ValidationResult.newResult(this.finalizeAndValidate(), new Recipe(this.inputs, (List<ItemStack>)this.outputs, (TObjectIntMap<ItemStack>)this.chancedOutputs, this.fluidInputs, this.fluidOutputs, (Map<String, Object>)ImmutableMap.of(), this.duration, this.EUt, this.hidden, this.needsEmptyOutput));
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("circuitMeta", this.circuitMeta).toString();
    }
}

