/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.oredict.OreIngredient;

public class CountableIngredient {
    private Ingredient ingredient;
    private int count;

    public static CountableIngredient from(ItemStack stack) {
        return new CountableIngredient(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}), stack.func_190916_E());
    }

    public static CountableIngredient from(ItemStack stack, int amount) {
        return new CountableIngredient(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}), amount);
    }

    public static CountableIngredient from(String oredict) {
        return new CountableIngredient((Ingredient)new OreIngredient(oredict), 1);
    }

    public static CountableIngredient from(String oredict, int count) {
        return new CountableIngredient((Ingredient)new OreIngredient(oredict), count);
    }

    public static CountableIngredient from(OrePrefix prefix, Material material) {
        return CountableIngredient.from(prefix, material, 1);
    }

    public static CountableIngredient from(OrePrefix prefix, Material material, int count) {
        return new CountableIngredient((Ingredient)new OreIngredient(new UnificationEntry(prefix, material).toString()), count);
    }

    public CountableIngredient(Ingredient ingredient, int count) {
        this.ingredient = ingredient;
        this.count = count;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountableIngredient that = (CountableIngredient)o;
        return this.count == that.count && Objects.equals(this.ingredient, that.ingredient);
    }

    public int hashCode() {
        return Objects.hash(this.ingredient, this.count);
    }

    public String toString() {
        return "CountableIngredient{ingredient=" + Arrays.toString(this.ingredient.func_193365_a()) + ", count=" + this.count + '}';
    }
}

