/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.tile;

import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.metatileentity.SyncedTileEntityBase;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.tile.AttachmentType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.unification.material.type.Material;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileEntityPipeBase<PipeType extends Enum<PipeType>, NodeDataType>
extends SyncedTileEntityBase
implements IPipeTile<PipeType, NodeDataType> {
    private TIntIntMap blockedConnectionsMap = new TIntIntHashMap();
    private int blockedConnections = 0;
    protected int insulationColor = 0x777777;
    protected final PipeCoverableImplementation coverableImplementation = new PipeCoverableImplementation(this);
    private NodeDataType cachedNodeData;
    private Material pipeMaterial;
    private BlockPipe<PipeType, NodeDataType, ?> pipeBlock;
    private PipeType pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[0];
    private boolean isBeingConverted;

    public boolean isBeingConverted() {
        return this.isBeingConverted;
    }

    public void setBeingConverted(boolean beingConverted) {
        this.isBeingConverted = beingConverted;
    }

    public void setPipeData(BlockPipe<PipeType, NodeDataType, ?> pipeBlock, PipeType pipeType, Material material) {
        this.pipeBlock = pipeBlock;
        this.pipeType = pipeType;
        this.pipeMaterial = material;
        if (!this.func_145831_w().field_72995_K) {
            this.writeCustomData(-4, buffer -> {
                buffer.func_150787_b(pipeType.ordinal());
                buffer.func_150787_b(Material.MATERIAL_REGISTRY.getIDForObject(this.pipeMaterial));
            });
        }
    }

    @Override
    public void transferDataFrom(IPipeTile<PipeType, NodeDataType> tileEntity) {
        this.pipeType = tileEntity.getPipeType();
        this.pipeMaterial = tileEntity.getPipeMaterial();
        this.blockedConnectionsMap = tileEntity.getBlockedConnectionsMap();
        this.insulationColor = tileEntity.getInsulationColor();
        tileEntity.getCoverableImplementation().transferDataTo(this.coverableImplementation);
        this.recomputeBlockedConnections();
    }

    public abstract Class<PipeType> getPipeTypeClass();

    @Override
    public abstract boolean supportsTicking();

    @Override
    public World getPipeWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getPipePos() {
        return this.func_174877_v();
    }

    @Override
    public PipeCoverableImplementation getCoverableImplementation() {
        return this.coverableImplementation;
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        return true;
    }

    @Override
    public IPipeTile<PipeType, NodeDataType> setSupportsTicking() {
        if (this.supportsTicking()) {
            return this;
        }
        TileEntityPipeBase<PipeType, NodeDataType> newTile = this.getPipeBlock().createNewTileEntity(true);
        newTile.transferDataFrom(this);
        this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)newTile);
        return newTile;
    }

    @Override
    public BlockPipe<PipeType, NodeDataType, ?> getPipeBlock() {
        if (this.pipeBlock == null) {
            Block block = this.getBlockState().func_177230_c();
            this.pipeBlock = block instanceof BlockPipe ? (BlockPipe)block : null;
        }
        return this.pipeBlock;
    }

    @Override
    public int getBlockedConnections() {
        return this.blockedConnections;
    }

    @Override
    public TIntIntMap getBlockedConnectionsMap() {
        return new TIntIntHashMap(this.blockedConnectionsMap);
    }

    @Override
    public int getInsulationColor() {
        return this.insulationColor;
    }

    @Override
    public void setInsulationColor(int insulationColor) {
        this.insulationColor = insulationColor;
        if (!this.func_145831_w().field_72995_K) {
            ((WorldPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(this.func_145831_w()))).updateMark(this.func_174877_v(), this.getCableMark());
            this.writeCustomData(-1, buffer -> buffer.writeInt(insulationColor));
            this.func_70296_d();
        }
    }

    @Override
    public boolean isConnectionBlocked(AttachmentType type, EnumFacing side) {
        int blockedConnections = this.blockedConnectionsMap.get(type.ordinal());
        return (blockedConnections & 1 << side.func_176745_a()) > 0;
    }

    @Override
    public void setConnectionBlocked(AttachmentType attachmentType, EnumFacing side, boolean blocked) {
        int blockedConnections = this.blockedConnectionsMap.get(attachmentType.ordinal());
        this.blockedConnectionsMap.put(attachmentType.ordinal(), this.withSideConnectionBlocked(blockedConnections, side, blocked));
        this.recomputeBlockedConnections();
        if (!this.func_145831_w().field_72995_K) {
            this.updateSideBlockedConnection(side);
            this.writeCustomData(-2, buffer -> buffer.func_150787_b(this.blockedConnections));
            this.func_70296_d();
        }
    }

    private void recomputeBlockedConnections() {
        int resultBlockedConnections = 0;
        for (int blockedConnections : this.blockedConnectionsMap.values()) {
            resultBlockedConnections |= blockedConnections;
        }
        this.blockedConnections = resultBlockedConnections;
    }

    private void updateSideBlockedConnection(EnumFacing side) {
        Object worldPipeNet = this.getPipeBlock().getWorldPipeNet(this.func_145831_w());
        boolean isSideBlocked = false;
        int sideIndex = 1 << side.func_176745_a();
        for (int blockedConnections : this.blockedConnectionsMap.values()) {
            isSideBlocked |= (blockedConnections & sideIndex) > 0;
        }
        ((WorldPipeNet)((Object)worldPipeNet)).updateBlockedConnections(this.func_174877_v(), side, isSideBlocked);
    }

    private int withSideConnectionBlocked(int blockedConnections, EnumFacing side, boolean blocked) {
        int index = 1 << side.func_176745_a();
        if (blocked) {
            return blockedConnections | index;
        }
        return blockedConnections & ~index;
    }

    @Override
    public PipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public Material getPipeMaterial() {
        return this.pipeMaterial;
    }

    @Override
    public NodeDataType getNodeData() {
        if (this.cachedNodeData == null) {
            this.cachedNodeData = this.getPipeBlock().createProperties(this);
        }
        return this.cachedNodeData;
    }

    private int getCableMark() {
        return this.insulationColor == 0x777777 ? 0 : this.insulationColor;
    }

    @Override
    public <T> T getCapabilityInternal(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == GregtechTileCapabilities.CAPABILITY_COVERABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_COVERABLE.cast((Object)this.getCoverableImplementation());
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    @Nullable
    public final <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        boolean isCoverable = capability == GregtechTileCapabilities.CAPABILITY_COVERABLE;
        CoverBehavior coverBehavior = facing == null ? null : this.coverableImplementation.getCoverAtSide(facing);
        T defaultValue = this.getCapabilityInternal(capability, facing);
        if (isCoverable) {
            return defaultValue;
        }
        if (coverBehavior == null && facing != null) {
            boolean isBlocked = (this.getBlockedConnections() & 1 << facing.func_176745_a()) > 0;
            return isBlocked ? null : (T)defaultValue;
        }
        if (coverBehavior != null && !isCoverable) {
            return coverBehavior.getCapability(capability, defaultValue);
        }
        return defaultValue;
    }

    public final boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        BlockPipe<PipeType, NodeDataType, ?> pipeBlock = this.getPipeBlock();
        if (pipeBlock != null) {
            compound.func_74778_a("PipeBlock", pipeBlock.getRegistryName().toString());
        }
        compound.func_74768_a("PipeType", ((Enum)this.pipeType).ordinal());
        compound.func_74778_a("PipeMaterial", this.pipeMaterial.toString());
        NBTTagCompound blockedConnectionsTag = new NBTTagCompound();
        for (int attachmentType : this.blockedConnectionsMap.keys()) {
            int blockedConnections = this.blockedConnectionsMap.get(attachmentType);
            blockedConnectionsTag.func_74768_a(Integer.toString(attachmentType), blockedConnections);
        }
        compound.func_74782_a("BlockedConnectionsMap", (NBTBase)blockedConnectionsTag);
        compound.func_74768_a("InsulationColor", this.insulationColor);
        this.coverableImplementation.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("PipeBlock", 8)) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(compound.func_74779_i("PipeBlock")));
            this.pipeBlock = block instanceof BlockPipe ? (BlockPipe)block : null;
        }
        this.pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[compound.func_74762_e("PipeType")];
        this.pipeMaterial = (Material)Material.MATERIAL_REGISTRY.func_82594_a(compound.func_74779_i("PipeMaterial"));
        NBTTagCompound blockedConnectionsTag = compound.func_74775_l("BlockedConnectionsMap");
        this.blockedConnectionsMap.clear();
        for (String attachmentTypeKey : blockedConnectionsTag.func_150296_c()) {
            int attachmentType = Integer.parseInt(attachmentTypeKey);
            int blockedConnections = blockedConnectionsTag.func_74762_e(attachmentTypeKey);
            this.blockedConnectionsMap.put(attachmentType, blockedConnections);
        }
        this.recomputeBlockedConnections();
        this.insulationColor = compound.func_74762_e("InsulationColor");
        this.coverableImplementation.readFromNBT(compound);
    }

    public void onLoad() {
        super.onLoad();
        this.coverableImplementation.onLoad();
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        buf.func_150787_b(((Enum)this.pipeType).ordinal());
        buf.func_150787_b(Material.MATERIAL_REGISTRY.getIDForObject(this.pipeMaterial));
        buf.func_150787_b(this.blockedConnections);
        buf.writeInt(this.insulationColor);
        this.coverableImplementation.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        this.pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[buf.func_150792_a()];
        this.pipeMaterial = Material.MATERIAL_REGISTRY.getObjectById(buf.func_150792_a());
        this.blockedConnections = buf.func_150792_a();
        this.insulationColor = buf.readInt();
        this.coverableImplementation.readInitialSyncData(buf);
    }

    @Override
    public void receiveCustomData(int discriminator, PacketBuffer buf) {
        if (discriminator == -1) {
            this.insulationColor = buf.readInt();
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == -2) {
            this.blockedConnections = buf.func_150792_a();
            this.scheduleChunkForRenderUpdate();
        } else if (discriminator == -3) {
            this.coverableImplementation.readCustomData(buf.func_150792_a(), buf);
        } else if (discriminator == -4) {
            this.pipeType = ((Enum[])this.getPipeTypeClass().getEnumConstants())[buf.func_150792_a()];
            this.pipeMaterial = Material.MATERIAL_REGISTRY.getObjectById(buf.func_150792_a());
            this.scheduleChunkForRenderUpdate();
        }
    }

    @Override
    public void writeCoverCustomData(int id, Consumer<PacketBuffer> writer) {
        this.writeCustomData(-3, buffer -> {
            buffer.func_150787_b(id);
            writer.accept((PacketBuffer)buffer);
        });
    }

    @Override
    public void scheduleChunkForRenderUpdate() {
        BlockPos pos = this.func_174877_v();
        this.func_145831_w().func_147458_c(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    @Override
    public void notifyBlockUpdate() {
        this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        this.getPipeBlock().updateActiveNodeStatus(this.func_145831_w(), this.func_174877_v(), this);
    }

    @Override
    public void markAsDirty() {
        this.func_70296_d();
    }

    @Override
    public boolean isValidTile() {
        return !this.func_145837_r();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

