/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.model;

import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.client.resources.data.PackMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ResourcePackHook
implements IResourceManagerReloadListener,
IResourcePack {
    public static final ResourcePackHook instance = new ResourcePackHook();
    private static ArrayList<IResourcePackFileHook> hooks = new ArrayList();

    private ResourcePackHook() {
    }

    public static void init() {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        Minecraft.func_71410_x().field_110449_ao.add(instance);
        if (resourceManager instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)resourceManager).func_110542_a((IResourceManagerReloadListener)instance);
        }
    }

    public static void addResourcePackFileHook(IResourcePackFileHook hook) {
        hooks.add(hook);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        for (IResourcePackFileHook hook : hooks) {
            hook.onResourceManagerReload((SimpleReloadableResourceManager)resourceManager);
        }
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        for (IResourcePackFileHook hook : hooks) {
            if (!hook.resourceExists(location)) continue;
            return hook.getInputStream(location);
        }
        throw new FileNotFoundException(location.toString());
    }

    public boolean func_110589_b(ResourceLocation location) {
        for (IResourcePackFileHook hook : hooks) {
            if (!hook.resourceExists(location)) continue;
            return true;
        }
        return false;
    }

    public Set<String> func_110587_b() {
        return ImmutableSet.of((Object)"gregtech");
    }

    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        if (metadataSectionName.equals("pack")) {
            return (T)new PackMetadataSection((ITextComponent)new TextComponentString(this.func_130077_b()), 1);
        }
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return ImageIO.read(Minecraft.class.getResource("/pack.png"));
    }

    public String func_130077_b() {
        return "Gregtech Internal Resource Pack";
    }

    public static interface IResourcePackFileHook {
        public boolean resourceExists(ResourceLocation var1);

        public InputStream getInputStream(ResourceLocation var1) throws IOException;

        public void onResourceManagerReload(SimpleReloadableResourceManager var1);
    }
}

