/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractBakedModel
implements IBakedModel {
    private VertexFormat format;

    public AbstractBakedModel(VertexFormat format) {
        this.format = format;
    }

    protected void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, TextureAtlasSprite sprite, double x, double y, double z, float u, float v, int rgbaColor) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float red = (float)(rgbaColor >> 16 & 0xFF) / 255.0f;
                    float green = (float)(rgbaColor >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(rgbaColor & 0xFF) / 255.0f;
                    builder.put(e, new float[]{red, green, blue, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    protected BakedQuad createQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, EnumFacing orientation, int rgbaColor) {
        Vec3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        if (sprite == null) {
            sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(sprite);
        this.putVertex(builder, normal, sprite, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f, rgbaColor);
        this.putVertex(builder, normal, sprite, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, 16.0f, rgbaColor);
        this.putVertex(builder, normal, sprite, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, 16.0f, 16.0f, rgbaColor);
        this.putVertex(builder, normal, sprite, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, 16.0f, 0.0f, rgbaColor);
        builder.setQuadOrientation(orientation);
        return builder.build();
    }
}

