/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import gregtech.api.enchants.EnchantmentData;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.api.unification.material.type.SolidMaterial;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public interface IToolStats {
    default public void onToolCrafted(ItemStack stack, EntityPlayer player) {
    }

    default public void onStatsAddedToTool(MetaItem.MetaValueItem metaValueItem) {
    }

    public int getToolDamagePerBlockBreak(ItemStack var1);

    default public int getToolDamagePerDropConversion(ItemStack stack) {
        return 0;
    }

    public int getToolDamagePerContainerCraft(ItemStack var1);

    public int getToolDamagePerEntityAttack(ItemStack var1);

    default public int getBaseQuality(ItemStack stack) {
        return 0;
    }

    default public float getBaseDamage(ItemStack stack) {
        return 1.0f;
    }

    default public float getDigSpeedMultiplier(ItemStack stack) {
        return 1.0f;
    }

    default public float getMaxDurabilityMultiplier(ItemStack stack) {
        return 1.0f;
    }

    default public List<EnchantmentData> getEnchantments(ItemStack stack) {
        return Collections.emptyList();
    }

    public boolean canApplyEnchantment(ItemStack var1, Enchantment var2);

    public boolean canMineBlock(IBlockState var1, ItemStack var2);

    default public boolean isCrowbar(ItemStack stack) {
        return false;
    }

    default public float getSaplingModifier(ItemStack stack, World world, EntityPlayer player, BlockPos pos) {
        return 0.0f;
    }

    default public List<BlockPos> getAOEBlocks(ItemStack itemStack, EntityPlayer player, RayTraceResult rayTraceResult) {
        return Collections.emptyList();
    }

    default public void onBlockDestroyed(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
    }

    default public boolean onBlockPreBreak(ItemStack stack, BlockPos blockPos, EntityPlayer player) {
        return false;
    }

    default public void convertBlockDrops(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, List<ItemStack> dropList, ItemStack toolStack) {
    }

    default public void addInformation(ItemStack stack, List<String> lines, boolean isAdvanced) {
    }

    default public float getNormalDamageBonus(EntityLivingBase entity, ItemStack stack, EntityLivingBase attacker) {
        return 0.0f;
    }

    default public float getMagicDamageBonus(EntityLivingBase entity, ItemStack stack, EntityLivingBase player) {
        return 0.0f;
    }

    default public float getAttackSpeed(ItemStack stack) {
        return -2.8f;
    }

    default public boolean canPerformSweepAttack(ItemStack stack) {
        return false;
    }

    default public boolean isUsingDurability(ItemStack stack) {
        return true;
    }

    default public ItemStack getBrokenStack(ItemStack stack) {
        return ItemStack.field_190927_a;
    }

    default public int getColor(ItemStack stack, int tintIndex) {
        SolidMaterial primaryMaterial = ToolMetaItem.getToolMaterial(stack);
        return tintIndex % 2 == 1 ? primaryMaterial.materialRGB : 0xFFFFFF;
    }
}

